Imports System.IO
Imports Foxit.PDF.Rasterizer

Namespace MonochromeImage_Example
    Friend Class Program
        Shared Sub Main(ByVal args() As String)
            Dim pdfPath As String = GetPDFPath()

            ' Create a PdfRasterizer object.
            Dim rasterizer As New PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"))

            ' Create a  BmpMonochromeColorFormat object.
            Dim bmpMonochromeColorFormat As New BmpMonochromeColorFormat(DitheringAlgorithm.FloydSteinberg, 100)

            ' Create a  BmpImageFormat object with BmpMonochromeColorFormat.
            Dim bmpImageFormat As New BmpImageFormat(bmpMonochromeColorFormat)

            ' Set the size.
            Dim fixedImageSize As New FixedImageSize(595, 841)

            ' Save the image.
            rasterizer.Draw("Monochrome.bmp", bmpImageFormat, fixedImageSize)
        End Sub
        Private Shared Function GetPDFPath() As String
            Dim pdfPath As String = AppDomain.CurrentDomain.BaseDirectory
            If pdfPath.EndsWith(New String(Path.DirectorySeparatorChar, 1)) Then
                pdfPath = Path.GetDirectoryName(pdfPath)
            End If
            Do While Directory.Exists(pdfPath) AndAlso Not Directory.Exists(Path.Combine(pdfPath, "PDFs"))
                pdfPath = Path.GetDirectoryName(pdfPath)
            Loop
            If pdfPath Is Nothing OrElse (Not Directory.Exists(Path.Combine(pdfPath, "PDFs"))) Then
                Throw New Exception("File path for pdf files could not be found.")
            End If

            Return pdfPath & "\PDFs"
        End Function
    End Class
End Namespace
