﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using Foxit.PDF.Rasterizer;
namespace GifImage_Example
{
    public partial class GifWithWebPaletteExample : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string pdfPath = GetPDFPath();

            //Create a PdfRasterizer
            PdfRasterizer rasterizer = new PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"));

            // Create a GifImageFormat object.
            GifImageFormat GifImageFormat = new GifImageFormat();

            // Set the DitheringAlgorithm to FloydSteinberg.
            GifImageFormat.DitheringAlgorithm = DitheringAlgorithm.FloydSteinberg;

            // Set the DitheringPercent.
            GifImageFormat.DitheringPercent = 100;

            // Set the palette type.
            GifImageFormat.ColorPalette = Palette.WebPalette;

            // Set the Antialiasing feture.
            GifImageFormat.AntiAliasing = true;

            // Set the size.
            FixedImageSize fixedImageSize = new FixedImageSize(595, 841);

            // Save the image.
            rasterizer.Draw(AppDomain.CurrentDomain.BaseDirectory + "\\Output\\GifWithWebPalette.Gif", GifImageFormat, fixedImageSize);

            // Display generated image in ImageBox.
            RasterizerOutput.ImageUrl = @"Output\GifWithWebPalette.Gif";
        }
        static string GetPDFPath()
        {
            string pdfPath = AppDomain.CurrentDomain.BaseDirectory;
            if (pdfPath.EndsWith(new string(Path.DirectorySeparatorChar, 1)))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            while (Directory.Exists(pdfPath) && !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            if (pdfPath == null || !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                throw new Exception("File path for pdf files could not be found.");
            }

            return pdfPath + "\\PDFs";
        }
    }
}
