﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using Foxit.PDF.Rasterizer;
namespace PngImage_Example
{
    public partial class PngRgbImageExample : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string pdfPath = GetPDFPath();

            //Create a PdfRasterizer
            PdfRasterizer rasterizer = new PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"));

            // Create a FixedImageSize object with required width and height.
            FixedImageSize fixedImageSize = new FixedImageSize(595, 841);

            //Create a PngImageFormat object with rgb color.
            PngImageFormat oPngImageFormat = new PngImageFormat(PngColorFormat.Rgb);

            // Save the image.
            rasterizer.Draw(AppDomain.CurrentDomain.BaseDirectory + "\\Output\\PngRgbImage.png", oPngImageFormat, fixedImageSize);

            // Display generated image in ImageBox.
            RasterizerOutput.ImageUrl = @"Output\PngRgbImage.png";
        }
        static string GetPDFPath()
        {
            string pdfPath = AppDomain.CurrentDomain.BaseDirectory;
            if (pdfPath.EndsWith(new string(Path.DirectorySeparatorChar, 1)))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            while (Directory.Exists(pdfPath) && !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            if (pdfPath == null || !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                throw new Exception("File path for pdf files could not be found.");
            }

            return pdfPath + "\\PDFs";
        }
    }
}
