﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using Foxit.PDF.Rasterizer;
namespace PngImage_Example
{
    public partial class PngImageWithUserPalette : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string pdfPath = GetPDFPath();

            //Create a PdfRasterizer
            PdfRasterizer rasterizer = new PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"));


            // Create a color array using custom colors.
            System.Drawing.Color[] color = new System.Drawing.Color[] { System.Drawing.Color.FromArgb(255,0,0,0),
            																	    System.Drawing.Color.FromArgb(255,255,255,255),
            																		System.Drawing.Color.FromArgb(255,255,0,0),
            																		System.Drawing.Color.FromArgb(255,0,255,0),
            																		System.Drawing.Color.FromArgb(255,0,0,255),
            																		System.Drawing.Color.FromArgb(255,255,255,0),
            																		System.Drawing.Color.FromArgb(255,0,255,255),
            																		System.Drawing.Color.FromArgb(255,255,0,255) };
            // Create a UserPalette object using Color array.																	 
            UserPalette userpalette = new UserPalette(color);

            // Create a PngIndexedColorFormat object. 
            PngIndexedColorFormat pngIndexedColorFormat = new PngIndexedColorFormat(userpalette,100,DitheringAlgorithm.FloydSteinberg);

            // Set the Colorpalette property to UserPalette.
            pngIndexedColorFormat.ColorPalette = userpalette;

            // Create a PngImageFormat object using PngIndexedColorFormat object. 
            PngImageFormat pngImageFormat = new PngImageFormat(pngIndexedColorFormat);

            // Set the size.
            FixedImageSize fixedImageSize = new FixedImageSize(595, 841);

            // Save the image.
            rasterizer.Draw(AppDomain.CurrentDomain.BaseDirectory + "\\Output\\PngImageWithUserPalette.png", pngImageFormat, fixedImageSize);

            // Display generated image in ImageBox.
            RasterizerOutput.ImageUrl = @"Output\PngImageWithUserPalette.png";
        }
        static string GetPDFPath()
        {
            string pdfPath = AppDomain.CurrentDomain.BaseDirectory;
            if (pdfPath.EndsWith(new string(Path.DirectorySeparatorChar, 1)))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            while (Directory.Exists(pdfPath) && !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            if (pdfPath == null || !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                throw new Exception("File path for pdf files could not be found.");
            }

            return pdfPath + "\\PDFs";
        }
    }
}
