﻿Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.IO
Imports Foxit.PDF.Rasterizer
Namespace PngImage_Example
    Partial Public Class PngRgbImageExample
        Inherits System.Web.UI.Page
        Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
            Dim pdfPath As String = GetPDFPath()

            'Create a PdfRasterizer
            Dim rasterizer As New PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"))

            ' Create a FixedImageSize object with required width and height.
            Dim fixedImageSize As New FixedImageSize(595, 841)

            'Create a PngImageFormat object with rgb color.
            Dim oPngImageFormat As New PngImageFormat(PngColorFormat.Rgb)

            ' Save the image.
            rasterizer.Draw(AppDomain.CurrentDomain.BaseDirectory & "\Output\PngRgbImage.png", oPngImageFormat, fixedImageSize)

            ' Display generated image in ImageBox.
            RasterizerOutput.ImageUrl = "Output\PngRgbImage.png"
        End Sub
        Private Shared Function GetPDFPath() As String
            Dim pdfPath As String = AppDomain.CurrentDomain.BaseDirectory
            If pdfPath.EndsWith(New String(Path.DirectorySeparatorChar, 1)) Then
                pdfPath = Path.GetDirectoryName(pdfPath)
            End If
            Do While Directory.Exists(pdfPath) AndAlso Not Directory.Exists(Path.Combine(pdfPath, "PDFs"))
                pdfPath = Path.GetDirectoryName(pdfPath)
            Loop
            If pdfPath Is Nothing OrElse (Not Directory.Exists(Path.Combine(pdfPath, "PDFs"))) Then
                Throw New Exception("File path for pdf files could not be found.")
            End If

            Return pdfPath & "\PDFs"
        End Function
    End Class
End Namespace
