﻿Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.IO
Imports System.Drawing
Imports Foxit.PDF.Rasterizer
Namespace PngImage_Example
    Partial Public Class PngImageWithUserPalette
        Inherits System.Web.UI.Page
        Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
            Dim pdfPath As String = GetPDFPath()

            'Create a PdfRasterizer
            Dim rasterizer As New PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"))

            ' Create a color array using custom colors.
            Dim color() As Color = {System.Drawing.Color.FromArgb(255, 0, 0, 0), System.Drawing.Color.FromArgb(255, 255, 255, 255), System.Drawing.Color.FromArgb(255, 255, 0, 0), System.Drawing.Color.FromArgb(255, 0, 255, 0), System.Drawing.Color.FromArgb(255, 0, 0, 255), System.Drawing.Color.FromArgb(255, 255, 255, 0), System.Drawing.Color.FromArgb(255, 0, 255, 255), System.Drawing.Color.FromArgb(255, 255, 0, 255)}

            ' Create a UserPalette object using Color array.																	 
            Dim userpalette As New UserPalette(color)

            ' Create a PngIndexedColorFormat object. 
            Dim pngIndexedColorFormat As New PngIndexedColorFormat(userpalette, 100, DitheringAlgorithm.FloydSteinberg)

            ' Set the Colorpalette property to UserPalette.
            pngIndexedColorFormat.ColorPalette = userpalette

            ' Create a PngImageFormat object using PngIndexedColorFormat object. 
            Dim pngImageFormat As New PngImageFormat(pngIndexedColorFormat)

            ' Set the size.
            Dim fixedImageSize As New FixedImageSize(595, 841)

            ' Save the image.
            rasterizer.Draw(AppDomain.CurrentDomain.BaseDirectory & "\Output\PngImageWithUserPalette.png", pngImageFormat, fixedImageSize)

            ' Display generated image in ImageBox.
            RasterizerOutput.ImageUrl = "Output\PngImageWithUserPalette.png"
        End Sub
        Private Shared Function GetPDFPath() As String
            Dim pdfPath As String = AppDomain.CurrentDomain.BaseDirectory
            If pdfPath.EndsWith(New String(Path.DirectorySeparatorChar, 1)) Then
                pdfPath = Path.GetDirectoryName(pdfPath)
            End If
            Do While Directory.Exists(pdfPath) AndAlso Not Directory.Exists(Path.Combine(pdfPath, "PDFs"))
                pdfPath = Path.GetDirectoryName(pdfPath)
            Loop
            If pdfPath Is Nothing OrElse (Not Directory.Exists(Path.Combine(pdfPath, "PDFs"))) Then
                Throw New Exception("File path for pdf files could not be found.")
            End If

            Return pdfPath & "\PDFs"
        End Function
    End Class
End Namespace
