<%@ Import Namespace="System" %>
<%@ Import Namespace="System.Drawing" %>
<%@ Import Namespace="System.Drawing.Imaging" %>
<%@ Import Namespace="System.Drawing.Drawing2D" %>
<%@ Page Language="C#" %> 
<%
	string filename = Request.QueryString["img"];
	string scale = Request.QueryString["scale"];
	int	width = Int32.Parse(Request.QueryString["width"]);
	int	height = Int32.Parse(Request.QueryString["height"]);
	bool orientation = Boolean.Parse(Request.QueryString["orientation"]);

	width  += 4;
	height += 4;

	System.Drawing.Image img_source = System.Drawing.Image.FromFile(Server.MapPath("")+"/"+filename);

	int orig_w = img_source.Width;
	int orig_h = img_source.Height;
	int orig_x = 0;
	int orig_y = 0;
	
	if (orientation && ((orig_w < orig_h && width > height) || (orig_w > orig_h && width < height))){
		int temp_width = width;
		width  = height;
		height = temp_width;
	};	
		
	float percent = 100;		
	switch(scale) {
		case "Fit":
			percent = Math.Min(width*100/orig_w, height*100/orig_h);
			break;
		case "Fill":
			percent = Math.Max(width*100/orig_w, height*100/orig_h);				
			break;
		case "Fix":
			percent = height*100/orig_h;				
			break;
	};			
	float npercent = ((float)percent/100);
	
	int dest_x = 0;
	int dest_y = 0; 
	int dest_w = (int)(orig_w * npercent);
	int dest_h = (int)(orig_h * npercent);			

	Bitmap thumb = new Bitmap(dest_w+1, dest_h+1, PixelFormat.Format24bppRgb);
	thumb.SetResolution(img_source.HorizontalResolution, img_source.VerticalResolution);

	Graphics gr_thumb = Graphics.FromImage(thumb);
	gr_thumb.InterpolationMode = InterpolationMode.HighQualityBicubic;
    
    gr_thumb.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
    gr_thumb.CompositingQuality = System.Drawing.Drawing2D.CompositingQuality.HighQuality;

    System.Drawing.Imaging.ImageCodecInfo codec = System.Drawing.Imaging.ImageCodecInfo.GetImageEncoders()[1];
    System.Drawing.Imaging.EncoderParameters eParams = new System.Drawing.Imaging.EncoderParameters(1);
    eParams.Param[0] = new System.Drawing.Imaging.EncoderParameter(System.Drawing.Imaging.Encoder.Quality, 100L);    
    
    gr_thumb.DrawImage(img_source, new Rectangle(dest_x-1,dest_y-1,dest_w+2,dest_h+2), new Rectangle(orig_x,orig_y,orig_w,orig_h), GraphicsUnit.Pixel);
	gr_thumb.Dispose();
	thumb.Save(Page.Response.OutputStream,codec,eParams);    
   	
    thumb.Dispose();
%>

