<?php
	header("Content-type: image/jpeg");	

	if (isset($_GET["img"])) $img = $_GET["img"];
	if (isset($_GET["width"])) $width = $_GET["width"];
	if (isset($_GET["height"])) $height = $_GET["height"];
	if (isset($_GET["scale"])) $scale = $_GET["scale"];
	if (isset($_GET["quality"])) $quality = $_GET["quality"];
	if (isset($_GET["bgcol"])) $bgcol = $_GET["bgcol"];   
	if (isset($_GET["orientation"])) $orientation = $_GET["orientation"]; 
	$orientation = ($orientation == "true") ? true : false;

	$source = imagecreatefromjpeg($img);
	$orig_w=imagesx($source);
	$orig_h=imagesy($source);  		
	
	if ($orientation && (($orig_w < $orig_h && $width > $height) || ($orig_w > $orig_h && $width < $height))){
		$temp_width = $width;
		$width  = $height;
		$height = $temp_width;
	};	 
   
	$percent = 100;		
	switch($scale) {
		case "Fit":
			$percent = min($width*100/$orig_w, $height*100/$orig_h);
			$width  = round($orig_w*$percent/100);
			$height = round($orig_h*$percent/100);
			break;
		case "Fill":
			$percent = max($width*100/$orig_w, $height*100/$orig_h);				
			break;
		case "Fix":
			$percent = $height*100/$orig_h;	
			$width = round($orig_w*$percent/100);
			break;			
	};				
	$thumb_w = round($orig_w*$percent/100);
	$thumb_h = round($orig_h*$percent/100);    
	
    $thumb=imagecreatetruecolor($width,$height);
	if (@$bgcol) imagefilledrectangle($thumb,0,0,$width-1,$height-1,intval($bgcol,16));	    
	imagecopyresampled($thumb,$source,round(($width-$thumb_w)/2),round(($height-$thumb_h)/2),0,0,$thumb_w,$thumb_h,$orig_w,$orig_h);
    if (!@$quality) $quality=100;
    imagejpeg($thumb,"",$quality);
    imagedestroy($thumb);
?> 