/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.ConsolePrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.Command;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.states.State;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.states.StateChangeExecutor;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.states.impl.TypeMode;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Scanner;

public class RmiConsole
implements StateChangeExecutor {
    private IRMIController rmiServer;
    private State consoleState;
    private OutputPrinter printer;

    public RmiConsole(String serverAddress, int serverPort) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(serverAddress, serverPort);
        this.rmiServer = (IRMIController)registry.lookup("SimulatorSNMP:" + serverPort);
        this.printer = new ConsolePrinter(System.out, System.err);
        this.consoleState = new TypeMode(this.printer, this.rmiServer, this);
    }

    public void runCmd(String command, String[] params) throws IOException {
        String[] parameters = params;
        if (parameters == null) {
            parameters = new String[]{};
        }
        ClientExecutionStatus status = null;
        for (Command consoleCommand : this.consoleState.getCommands()) {
            if (!consoleCommand.canParse(command)) continue;
            status = consoleCommand.execute(command, parameters);
            break;
        }
        if (status != null && !status.isExecutedCorrectly()) {
            this.printer.printError(status.getMessage());
        }
    }

    public State getState() {
        return this.consoleState;
    }

    public String getWelcome() throws RemoteException {
        return this.rmiServer.cmdGetWelcome().getResult();
    }

    @Override
    public void doChangeState(State newState) {
        this.consoleState = newState;
    }

    @Override
    public void doShutDown() {
        System.exit(0);
    }

    public String readInput(Scanner in) {
        return in.nextLine();
    }
}

