/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import com.veraxsystems.simulatorSNMP.rmi.types.DeviceState;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class AddDevice
extends AbstractCommand {
    private static final String CMD = "ADD";
    private static final int REQUIRED_PARAM_COUNT = 3;
    private static final int ADDRESS_INDEX = 0;
    private static final int NETMASK_INDEX = 1;
    private static final int PORT_INDEX = 2;
    private static final int STATE_INDEX = 3;
    private static final int COMMUNITY_INDEX = 4;
    private static final int WRITE_COMMUNITY_INDEX = 5;
    private static Logger logger = Logger.getLogger(AddDevice.class);
    private IRMIController controller;
    private int typeId;

    public AddDevice(OutputPrinter printer, IRMIController controller, int typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status;
        block8: {
            status = new ClientExecutionStatus();
            if (parameters.length >= 3) {
                try {
                    ExecutionStatus executionStatus;
                    DeviceState state = DeviceState.running;
                    if (parameters.length >= 4) {
                        state = DeviceState.parseState(parameters[3].toLowerCase());
                    }
                    if ((executionStatus = parameters.length >= 5 ? this.controller.cmdAddDevice(this.typeId, parameters[0], parameters[1], parameters[2], state, parameters[4], parameters[5]) : (parameters.length >= 5 ? this.controller.cmdAddDevice(this.typeId, parameters[0], parameters[1], parameters[2], state, parameters[4], parameters[4]) : this.controller.cmdAddDevice(this.typeId, parameters[0], parameters[1], parameters[2], state))).isExecutedCorrectly()) {
                        this.getPrinter().print("[ADD] Device added successfully");
                        break block8;
                    }
                    status.addMessage("[ADD] Failed to create device, cause: " + executionStatus.getMessage());
                }
                catch (NumberFormatException e) {
                    status.addMessage(e.getMessage());
                    logger.error(e.getMessage(), e);
                }
                catch (RemoteException e) {
                    status.addMessage(e.getMessage());
                    logger.error(e.getMessage(), e);
                }
                catch (IllegalArgumentException e) {
                    String msg = "[ADD] Invalid device state. Allowed values are: RUNNING|STOPPED|DISABLED";
                    status.addMessage(msg);
                    logger.error(msg, e);
                }
            } else {
                String msg = "[ADD] Failed to create device. Expected parameters: 3, got: " + parameters.length;
                status.addMessage(msg);
                logger.error(msg);
            }
        }
        return status;
    }
}

