/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.IntegerExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class AddType
extends AbstractCommand {
    private static final String CMD = "ADD";
    private static Logger logger = Logger.getLogger(AddType.class);
    private IRMIController controller;

    public AddType(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status = new ClientExecutionStatus();
        StringBuilder path = new StringBuilder();
        for (String str : parameters) {
            path.append(str);
            path.append(" ");
        }
        try {
            ExecutionStatus executionStatus = this.controller.cmdAddType(path.toString().trim());
            if (executionStatus.isExecutedCorrectly()) {
                this.getPrinter().print("[ADD] Created device type for paths: " + path);
                if (executionStatus instanceof IntegerExecutionStatus) {
                    this.getPrinter().print("[ADD] Device type ID: " + ((IntegerExecutionStatus)executionStatus).getResult());
                }
            } else {
                String msg = "[ADD] Failed to add path: " + path;
                status.addMessage(msg);
                status.addMessage(executionStatus.getMessage());
                logger.error(msg);
            }
        }
        catch (RemoteException e) {
            status.addMessage(e.getMessage());
            logger.error(e.getMessage(), e);
        }
        return status;
    }
}

