/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class DeleteType
extends AbstractCommand {
    private static final String CMD = "DELETE";
    private static final int PARAM_CNT = 1;
    private static final int PATH_INDEX = 0;
    private IRMIController controller;
    private static Logger logger = Logger.getLogger(DeleteType.class);

    public DeleteType(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result;
        block5: {
            result = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                try {
                    String path = parameters[0];
                    ExecutionStatus executionStatus = this.controller.cmdDeleteTypeFile(path);
                    if (!executionStatus.isExecutedCorrectly()) {
                        String msg = "[DELETE] Failed to delete type file";
                        result.addMessage(msg);
                        logger.error(msg);
                        result.addMessage(executionStatus.getMessage());
                        break block5;
                    }
                    this.getPrinter().print("[DELETE] Type file deleted");
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), e);
                    result.addMessage("[DOWNLOADTYPE] " + e.getMessage());
                }
            } else {
                String msg = "[DELETE] Failed to delete type file. Expected parameters: 1, got: " + parameters.length;
                logger.error(msg);
                result.addMessage(msg);
            }
        }
        return result;
    }
}

