/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.StringExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class DownloadType
extends AbstractCommand {
    private static final String CMD = "DOWNLOADTYPE";
    private static final int PARAM_CNT = 1;
    private static final int TYPEID_INDEX = 0;
    private IRMIController controller;
    private static Logger logger = Logger.getLogger(DownloadType.class);

    public DownloadType(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result;
        block6: {
            result = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                try {
                    int typeId = Integer.parseInt(parameters[0]);
                    StringExecutionStatus executionStatus = this.controller.cmdDownloadTypeFile(typeId);
                    if (!executionStatus.isExecutedCorrectly()) {
                        String msg = "[DOWNLOADTYPE] Failed to download type";
                        result.addMessage(msg);
                        logger.error(msg);
                        result.addMessage(executionStatus.getMessage());
                        break block6;
                    }
                    this.getPrinter().print(executionStatus.getResult());
                }
                catch (NumberFormatException e) {
                    String msg = "[DOWNLOADTYPE] Invalid type ID format";
                    logger.error(msg, e);
                    result.addMessage(msg);
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), e);
                    result.addMessage("[DOWNLOADTYPE] " + e.getMessage());
                }
            } else {
                String msg = "[DOWNLOADTYPE] Failed to download type file. Expected parameters: 1, got: " + parameters.length;
                logger.error(msg);
                result.addMessage(msg);
            }
        }
        return result;
    }
}

