/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.StringExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import org.apache.log4j.Logger;

public class GenerateHardwareLicenseRequest
extends AbstractCommand {
    private static final String CMD = "HLREQ";
    private IRMIController controller;
    private static Logger logger = Logger.getLogger(GenerateHardwareLicenseRequest.class);

    public GenerateHardwareLicenseRequest(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus status = new ClientExecutionStatus();
        String result = "";
        try {
            StringExecutionStatus executionStatus = this.controller.cmdGenerateHardwareLicenceRequest();
            if (executionStatus.isExecutedCorrectly()) {
                result = executionStatus.getResult();
                this.getPrinter().print(result);
            } else {
                String msg = "[HLREQ] Failed generate hardware license request";
                status.addMessage(msg);
                status.addMessage(executionStatus.getMessage());
                logger.error(msg);
            }
        }
        catch (Exception e) {
            String msg = "[SHOW] " + e.getMessage();
            logger.error(msg, e);
            status.addMessage(msg);
        }
        return status;
    }
}

