/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.StringExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class GetSimulatorHome
extends AbstractCommand {
    private static final String CMD = "HOME";
    private static Logger logger = Logger.getLogger(GetSimulatorHome.class);
    private IRMIController controller;

    public GetSimulatorHome(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result = new ClientExecutionStatus();
        try {
            StringExecutionStatus executionStatus = this.controller.cmdGetSimulatorHome();
            if (executionStatus.isExecutedCorrectly()) {
                String simulatorHome = executionStatus.getResult();
                this.getPrinter().print(simulatorHome);
            } else {
                String msg = "[HOME] Failed to display ${SIMULATOR_HOME}";
                logger.error(msg);
                result.addMessage(msg);
                result.addMessage(executionStatus.getMessage());
            }
        }
        catch (RemoteException e) {
            logger.error(e.getMessage(), e);
            result.addMessage(e.getMessage());
        }
        return result;
    }
}

