/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.client.help.HelpPrinter;
import com.veraxsystems.simulatorSNMP.rmi.commands.StringListExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class ListTypes
extends AbstractCommand {
    private static final String CMD = "LISTTYPES";
    private IRMIController controller;
    private static Logger logger = Logger.getLogger(ListTypes.class);

    public ListTypes(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result = new ClientExecutionStatus();
        try {
            StringListExecutionStatus executionStatus = this.controller.cmdGetAvailableTypes();
            if (!executionStatus.isExecutedCorrectly()) {
                String msg = "[LISTTYPES] Failed to list types";
                result.addMessage(msg);
                logger.error(msg);
                result.addMessage(executionStatus.getMessage());
            } else {
                HelpPrinter.printAvailableDevices(this.getPrinter(), executionStatus.getResult());
            }
        }
        catch (RemoteException e) {
            logger.error(e.getMessage(), e);
            result.addMessage("[LISTTYPES] " + e.getMessage());
        }
        return result;
    }
}

