/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class RemoveDevice
extends AbstractCommand {
    private static final String CMD = "REMOVE";
    private static final int PARAM_CNT = 1;
    private static final int ID_INDEX = 0;
    private static Logger logger = Logger.getLogger(RemoveDevice.class);
    private IRMIController controller;
    private int typeId;

    public RemoveDevice(OutputPrinter printer, IRMIController controller, int typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status;
        block6: {
            status = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                Integer tmpId = Integer.parseInt(parameters[0]);
                try {
                    this.getPrinter().print("Removing device " + tmpId + "...");
                    ExecutionStatus executionStatus = this.controller.cmdRemove(this.typeId, tmpId);
                    if (executionStatus.isExecutedCorrectly()) {
                        this.getPrinter().print("Device " + tmpId + " removed successfully!");
                        break block6;
                    }
                    String msg = "[REMOVE] Failed to remove device " + tmpId + ". Cause: invalid ID";
                    logger.error(msg);
                    status.addMessage(msg);
                    status.addMessage(executionStatus.getMessage());
                }
                catch (NumberFormatException e) {
                    String msg = "[REMOVE] Invalid ID format";
                    logger.error(msg, e);
                    status.addMessage(msg);
                }
                catch (RemoteException e) {
                    String msg = "[REMOVE] " + e.getMessage();
                    logger.error(msg, e);
                    status.addMessage(msg);
                }
            } else {
                String msg = "[REMOVE] Failed to remove device. Expected parameters: 1, got: " + parameters.length;
                status.addMessage(msg);
                logger.error(msg);
            }
        }
        return status;
    }
}

