/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class RemoveType
extends AbstractCommand {
    private static final String CMD = "REMOVE";
    private static Logger logger = Logger.getLogger(RemoveType.class);
    private IRMIController controller;

    public RemoveType(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status = new ClientExecutionStatus();
        try {
            Integer tmpId = Integer.parseInt(parameters[0]);
            ExecutionStatus executionStatus = this.controller.cmdRemove(tmpId);
            if (executionStatus.isExecutedCorrectly()) {
                this.getPrinter().print("[REMOVE] Type " + tmpId + " removed successfully!");
            } else {
                String msg = "[REMOVE] Invalid type ID: " + tmpId;
                logger.error(msg);
                status.addMessage(msg);
                status.addMessage(executionStatus.getMessage());
            }
        }
        catch (NumberFormatException e) {
            String msg = "[REMOVE] Invalid ID format";
            logger.error(msg, e);
            status.addMessage(msg);
        }
        catch (RemoteException e) {
            String msg = "[REMOVE] " + e.getMessage();
            logger.error(msg, e);
            status.addMessage(msg);
        }
        return status;
    }
}

