/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class ReplaceType
extends AbstractCommand {
    private static final String CMD = "REPLACETYPE";
    private static final int PARAM_CNT = 1;
    private static final int SOURCE_PATH_INDEX = 0;
    private IRMIController controller;
    private static Logger logger = Logger.getLogger(ReplaceType.class);
    private int typeId;

    public ReplaceType(OutputPrinter printer, IRMIController controller, int typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result;
        block7: {
            result = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                String src = parameters[0];
                File file = new File(src);
                if (file.exists() && file.canRead()) {
                    try {
                        String content = new Scanner(file).useDelimiter("\\Z").next();
                        ExecutionStatus executionStatus = this.controller.cmdReplaceType(this.typeId, content);
                        if (!executionStatus.isExecutedCorrectly()) {
                            String msg = "[REPLACETYPE] Failed to replace type";
                            result.addMessage(msg);
                            logger.error(msg);
                            result.addMessage(executionStatus.getMessage());
                            break block7;
                        }
                        this.getPrinter().print("[REPLACETYPE] Type replaced successfully!");
                    }
                    catch (RemoteException e) {
                        logger.error(e.getMessage(), e);
                        result.addMessage("[UPLOADTYPE] " + e.getMessage());
                    }
                } else {
                    String msg = "[REPLACETYPE] Failed to replace type file. Invalid source file path";
                    logger.error(msg);
                    result.addMessage(msg);
                }
            } else {
                String msg = "[REPLACETYPE] Failed to replace type file. Expected parameters: 1, got: " + parameters.length;
                logger.error(msg);
                result.addMessage(msg);
            }
        }
        return result;
    }
}

