/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class Save
extends AbstractCommand {
    private static final String CMD = "SAVE";
    private static Logger logger = Logger.getLogger(Save.class);
    private static final int OPTIONAL_PARAM_COUNT = 1;
    private static final int PATH_INDEX = 0;
    private IRMIController controller;

    public Save(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status = new ClientExecutionStatus();
        try {
            ExecutionStatus executionStatus = this.controller.cmdSave(parameters.length >= 1 ? parameters[0] : null);
            if (executionStatus.isExecutedCorrectly()) {
                this.getPrinter().print("[SAVE] Save completed successfully!");
            } else {
                String msg = "[SAVE] Failed to execute save";
                logger.error(msg);
                status.addMessage(msg);
                status.addMessage(executionStatus.getMessage());
            }
        }
        catch (RemoteException e) {
            String msg = "[SAVE] " + e.getMessage();
            logger.error(msg, e);
            status.addMessage(msg);
        }
        return status;
    }
}

