/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.StateChangeAbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.states.StateChangeExecutor;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.states.impl.DeviceMode;
import com.veraxsystems.simulatorSNMP.rmi.commands.BooleanExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class Select
extends StateChangeAbstractCommand {
    private static final String CMD = "SELECT";
    private static final int PARAM_CNT = 1;
    private static final int ID_INDEX = 0;
    private static Logger logger = Logger.getLogger(Select.class);
    private IRMIController controller;

    public Select(OutputPrinter printer, StateChangeExecutor executor, IRMIController controller) {
        super(printer, CMD, executor);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus result;
        block7: {
            result = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                try {
                    Integer tmpId = Integer.parseInt(parameters[0]);
                    BooleanExecutionStatus executionStatus = this.controller.cmdHasTypeWithID(tmpId);
                    if (!executionStatus.isExecutedCorrectly()) {
                        String msg = "[SELECT] Failed to execute select";
                        result.addMessage(msg);
                        logger.error(msg);
                        result.addMessage(executionStatus.getMessage());
                        break block7;
                    }
                    if (!executionStatus.getResult().booleanValue()) {
                        String msg = "[SELECT] Invalid type ID";
                        result.addMessage(msg);
                        logger.error(msg);
                        break block7;
                    }
                    this.getExecutor().doChangeState(new DeviceMode(this.getPrinter(), this.controller, this.getExecutor(), tmpId));
                    logger.debug("Entering type " + tmpId);
                }
                catch (NumberFormatException e) {
                    String msg = "[SELECT] Invalid type ID format";
                    logger.error(msg, e);
                    result.addMessage(msg);
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), e);
                    result.addMessage("[SELECT] " + e.getMessage());
                }
            } else {
                String msg = "[SELECT] Failed to select type. Expected parameters: 1, got: " + parameters.length;
                logger.error(msg);
                result.addMessage(msg);
            }
        }
        return result;
    }
}

