/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.client.help.HelpPrinter;
import com.veraxsystems.simulatorSNMP.rmi.commands.TypeListExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.dto.TypeDTO;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.util.List;
import org.apache.log4j.Logger;

public class ShowType
extends AbstractCommand {
    private static final String CMD = "SHOW";
    private static Logger logger = Logger.getLogger(ShowType.class);
    private IRMIController controller;

    public ShowType(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status = new ClientExecutionStatus();
        try {
            TypeListExecutionStatus executionStatus = this.controller.cmdGetStates();
            if (executionStatus.isExecutedCorrectly()) {
                List<TypeDTO> data = executionStatus.getResult();
                for (TypeDTO type : data) {
                    HelpPrinter.printType(this.getPrinter(), type);
                    this.getPrinter().print("");
                }
            } else {
                String msg = "[SHOW] Failed to show type";
                logger.error(msg);
                status.addMessage(msg);
                status.addMessage(executionStatus.getMessage());
            }
        }
        catch (Exception e) {
            String msg = "[SHOW] " + e.getMessage();
            logger.error(msg, e);
            status.addMessage(msg);
        }
        return status;
    }
}

