/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class Start
extends AbstractCommand {
    private static final String CMD = "START";
    private static final int PARAM_CNT = 1;
    private static final int ID_INDEX = 0;
    private static Logger logger = Logger.getLogger(Start.class);
    private IRMIController controller;
    private int typeId;

    public Start(OutputPrinter printer, IRMIController controller, int typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status;
        block7: {
            status = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                try {
                    Integer tmpId = Integer.parseInt(parameters[0]);
                    this.getPrinter().print("[START] Starting device " + tmpId + "...");
                    ExecutionStatus executionStatus = this.controller.cmdStartDevice(this.typeId, tmpId);
                    if (executionStatus.isExecutedCorrectly()) {
                        this.getPrinter().print("[START] Device " + tmpId + " started successfully!");
                        break block7;
                    }
                    String msg = "[START] Failed to start device " + tmpId;
                    logger.error(msg);
                    status.addMessage(msg);
                    status.addMessage(executionStatus.getMessage());
                }
                catch (NumberFormatException e) {
                    String msg = "[START] Wrong type id format.";
                    logger.error(msg, e);
                    status.addMessage(msg);
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), e);
                    status.addMessage("[START] " + e.getMessage());
                }
                catch (IOException e) {
                    String msg = "[START] Failed to start device";
                    logger.error(msg);
                    status.addMessage(msg);
                }
            } else {
                String msg = "[START] Failed to select device. Expected parameters: 1, got: " + parameters.length;
                logger.error(msg);
                status.addMessage(msg);
            }
        }
        return status;
    }
}

