/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class StartAll
extends AbstractCommand {
    private static final String CMD = "STARTALL";
    private static Logger logger = Logger.getLogger(StartAll.class);
    private IRMIController controller;
    private Integer typeId;

    public StartAll(OutputPrinter printer, IRMIController controller, Integer typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result = new ClientExecutionStatus();
        try {
            this.getPrinter().print("Starting devices...");
            ExecutionStatus executionStatus = this.controller.cmdStartAll(this.typeId);
            if (executionStatus.isExecutedCorrectly()) {
                this.getPrinter().print("Devices started successfully!");
            } else {
                String msg = "[STARTALL] Failed to start devices";
                logger.error(msg);
                result.addMessage(msg);
                result.addMessage(executionStatus.getMessage());
            }
        }
        catch (RemoteException e) {
            logger.error(e.getMessage(), e);
            result.addMessage(e.getMessage());
        }
        return result;
    }
}

