/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class Stop
extends AbstractCommand {
    private static final String CMD = "STOP";
    private static final int PARAM_CNT = 1;
    private static final int ID_INDEX = 0;
    private static Logger logger = Logger.getLogger(Stop.class);
    private IRMIController controller;
    private int typeId;

    public Stop(OutputPrinter printer, IRMIController controller, int typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status;
        block6: {
            status = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                try {
                    Integer tmpId = Integer.parseInt(parameters[0]);
                    this.getPrinter().print("[STOP] Stopping device " + tmpId + "...");
                    ExecutionStatus executionStatus = this.controller.cmdStopDevice(this.typeId, tmpId);
                    if (executionStatus.isExecutedCorrectly()) {
                        this.getPrinter().print("[STOP] Device " + tmpId + " stopped successfully!");
                        break block6;
                    }
                    String msg = "[STOP] Failed to stop device " + tmpId;
                    logger.error(msg);
                    status.addMessage(msg);
                    status.addMessage(executionStatus.getMessage());
                }
                catch (NumberFormatException e) {
                    String msg = "[STOP] Wrong type id format.";
                    logger.error(msg, e);
                    status.addMessage(msg);
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), e);
                    status.addMessage("[STOP] " + e.getMessage());
                }
            } else {
                String msg = "[STOP] Failed to stop device. Expected parameters: 1, got: " + parameters.length;
                logger.error(msg);
                status.addMessage(msg);
            }
        }
        return status;
    }
}

