/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class StopAll
extends AbstractCommand {
    private static final String CMD = "STOPALL";
    private static Logger logger = Logger.getLogger(StopAll.class);
    private IRMIController controller;
    private Integer typeId;

    public StopAll(OutputPrinter printer, IRMIController controller, Integer typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status = new ClientExecutionStatus();
        try {
            this.getPrinter().print("Stopping devices...");
            ExecutionStatus executionStatus = this.controller.cmdStopAll(this.typeId);
            if (executionStatus.isExecutedCorrectly()) {
                this.getPrinter().print("[STOPALL] Devices stopped successfully!");
            } else {
                String msg = "[STOPALL] Failed to stop devices";
                logger.error(msg);
                status.addMessage(msg);
                status.addMessage(executionStatus.getMessage());
            }
        }
        catch (RemoteException e) {
            logger.error(e.getMessage(), e);
            status.addMessage(e.getMessage());
        }
        return status;
    }
}

