/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.client.help.HelpPrinter;
import com.veraxsystems.simulatorSNMP.rmi.commands.TypeExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.dto.TypeDTO;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class SummaryDevice
extends AbstractCommand {
    private static final String CMD = "SUMMARY";
    private static Logger logger = Logger.getLogger(SummaryDevice.class);
    private IRMIController controller;
    private int typeId;

    public SummaryDevice(OutputPrinter printer, IRMIController controller, int typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.typeId = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus status = new ClientExecutionStatus();
        try {
            TypeExecutionStatus executionStatus = this.controller.cmdGetState(this.typeId);
            if (executionStatus.isExecutedCorrectly()) {
                TypeDTO data = executionStatus.getResult();
                HelpPrinter.printTypeSummary(this.getPrinter(), data);
            } else {
                String msg = "[SUMMARY] Failed to display summary for type";
                logger.error(msg);
                status.addMessage(msg);
                status.addMessage(executionStatus.getMessage());
            }
        }
        catch (RemoteException e) {
            String msg = "[SUMMARY] " + e.getMessage();
            logger.error(msg, e);
            status.addMessage(msg);
        }
        return status;
    }
}

