/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class UpdateOid
extends AbstractCommand {
    private static final String CMD = "UPDATEOID";
    private static final int PARAM_CNT = 2;
    private static final int NEWVALUE_INDEX = 1;
    private static final int OID_INDEX = 0;
    private IRMIController controller;
    private static Logger logger = Logger.getLogger(UpdateOid.class);
    private int id;

    public UpdateOid(OutputPrinter printer, IRMIController controller, int typeId) {
        super(printer, CMD);
        this.controller = controller;
        this.id = typeId;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result;
        block7: {
            result = new ClientExecutionStatus();
            if (parameters.length >= 2) {
                try {
                    String oid = parameters[0];
                    StringBuilder sb = new StringBuilder(parameters[1]);
                    for (int i = 2; i < parameters.length; ++i) {
                        sb.append(" ");
                        sb.append(parameters[i]);
                    }
                    String value = sb.toString();
                    ExecutionStatus executionStatus = this.controller.cmdUpdateOid(this.id, oid, value);
                    if (!executionStatus.isExecutedCorrectly()) {
                        String msg = "[UPDATEOID] Failed to update OID";
                        result.addMessage(msg);
                        logger.error(msg);
                        result.addMessage(executionStatus.getMessage());
                        break block7;
                    }
                    this.getPrinter().print("[UPDATEOID] OID updated successfully!");
                }
                catch (NumberFormatException e) {
                    String msg = "[UPDATEOID] Invalid type ID format";
                    logger.error(msg, e);
                    result.addMessage(msg);
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), e);
                    result.addMessage("[UPDATEOID] " + e.getMessage());
                }
            } else {
                String msg = "[UPDATEOID] Failed to update OID. Expected parameters: 2, got: " + parameters.length;
                logger.error(msg);
                result.addMessage(msg);
            }
        }
        return result;
    }
}

