/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class UploadType
extends AbstractCommand {
    private static final String CMD = "UPLOADTYPE";
    private static final int PARAM_CNT = 2;
    private static final int TARGET_PATH_INDEX = 1;
    private static final int SOURCE_PATH_INDEX = 0;
    private IRMIController controller;
    private static Logger logger = Logger.getLogger(UploadType.class);

    public UploadType(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) throws IOException {
        ClientExecutionStatus result;
        block7: {
            result = new ClientExecutionStatus();
            if (parameters.length >= 2) {
                String src = parameters[0];
                String target = parameters[1];
                File file = new File(src);
                if (file.exists() && file.canRead()) {
                    try {
                        String content = new Scanner(file).useDelimiter("\\Z").next();
                        ExecutionStatus executionStatus = this.controller.cmdUploadTypeFile(target, content);
                        if (!executionStatus.isExecutedCorrectly()) {
                            String msg = "[UPLOADTYPE] Failed to upload type";
                            result.addMessage(msg);
                            logger.error(msg);
                            result.addMessage(executionStatus.getMessage());
                            break block7;
                        }
                        this.getPrinter().print("[UPLOADTYPE] Type uploaded successfully!");
                    }
                    catch (RemoteException e) {
                        logger.error(e.getMessage(), e);
                        result.addMessage("[UPLOADTYPE] " + e.getMessage());
                    }
                } else {
                    String msg = "[UPLOADTYPE] Failed to upload type file. Invalid source file path";
                    logger.error(msg);
                    result.addMessage(msg);
                }
            } else {
                String msg = "[UPLOADTYPE] Failed to upload type file. Expected parameters: 2, got: " + parameters.length;
                logger.error(msg);
                result.addMessage(msg);
            }
        }
        return result;
    }
}

