/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.impl;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.AbstractCommand;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.commands.ClientExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.BooleanExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class ValidateType
extends AbstractCommand {
    private static final String CMD = "VALIDATE";
    private static Logger logger = Logger.getLogger(ValidateType.class);
    private static final int PARAM_CNT = 1;
    private static final int ID_INDEX = 0;
    private IRMIController controller;

    public ValidateType(OutputPrinter printer, IRMIController controller) {
        super(printer, CMD);
        this.controller = controller;
    }

    @Override
    public ClientExecutionStatus execute(String command, String[] parameters) {
        ClientExecutionStatus result;
        block10: {
            result = new ClientExecutionStatus();
            if (parameters.length >= 1) {
                try {
                    Integer tmpId = Integer.parseInt(parameters[0]);
                    BooleanExecutionStatus executionStatus = this.controller.cmdHasTypeWithID(tmpId);
                    if (!executionStatus.isExecutedCorrectly()) {
                        String msg = "[VALIDATE] Failed to execute validate";
                        result.addMessage(msg);
                        logger.error(msg);
                        result.addMessage(executionStatus.getMessage());
                        break block10;
                    }
                    if (!executionStatus.getResult().booleanValue()) {
                        String msg = "[VALIDATE] Invalid type ID";
                        result.addMessage(msg);
                        logger.error(msg);
                        break block10;
                    }
                    BooleanExecutionStatus booleanExecutionStatus = this.controller.cmdValidateType(tmpId);
                    if (!booleanExecutionStatus.isExecutedCorrectly()) {
                        String msg = "[VALIDATE] Failed to execute validate";
                        result.addMessage(msg);
                        logger.error(msg);
                        result.addMessage(executionStatus.getMessage());
                        break block10;
                    }
                    if (!booleanExecutionStatus.getResult().booleanValue()) {
                        this.getPrinter().print("[VALIDATE] Errors found in type file:\n");
                        for (String oid : booleanExecutionStatus.getErrors().keySet()) {
                            this.getPrinter().print(oid + ": " + booleanExecutionStatus.getErrors().get(oid) + "\n");
                        }
                        break block10;
                    }
                    this.getPrinter().print("[VALIDATE] Type successfully validated");
                }
                catch (NumberFormatException e) {
                    String msg = "[VALIDATE] Invalid type ID format";
                    logger.error(msg, e);
                    result.addMessage(msg);
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), e);
                    result.addMessage("[VALIDATE] " + e.getMessage());
                }
            } else {
                String msg = "[VALIDATE] Failed to validate type. Expected parameters: 1, got: " + parameters.length;
                logger.error(msg);
                result.addMessage(msg);
            }
        }
        return result;
    }
}

