/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.help;

import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.dto.DeviceDTO;
import com.veraxsystems.simulatorSNMP.rmi.dto.TypeDTO;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class HelpPrinter {
    private static final int SUMMARY_INITIALIZED = 0;
    private static final int SUMMARY_READY = 1;
    private static final int SUMMARY_FINISHED = 2;
    private static final int SUMMARY_RUNNING = 3;
    private static final int SUMMARY_STOPPED = 4;
    private static final int SUMMARY_UNKNOWN = 5;
    private static final int MAX_LENGTH = 22;
    public static final String[][] UNIVERSAL_COMMAND = new String[][]{{"EXIT|FINISH", "Disconnect console from server."}, {"END", "Shutdown server.All device instances will be shut down."}, {"SELECT [type_id]", "Select device type identified by [type_id] and go to device mode."}, {"SHOW", "Display the list of all the devices in the system."}, {"STARTALL", "Start simulation of all current device types."}, {"STATUS", "Display version of the server and number of the available devices"}, {"STOPALL", "Stop simulation of all current device types."}, {"SUMMARY", "Display the list of all the device types in the system."}};
    public static final String[][] FIRST_LEVEL_COMMAND = new String[][]{{"ADD [filepath]", "Add new device type using <FILE> file.To start simulation, go to device mode (using SELECT command).and add device (using ADD command)."}, {"REMOVE [type_id]", "Remove device type identified by <ID>.All devices of selected type will be removed."}, {"HLREQ", "Generate hardware license request"}, {"LISTTYPES", "Lists paths to available type files"}, {"UPLOADTYPE [source_path] [target_path]", "Upload type file defined by <source_path> to simulator server and save it in ${SIMULATOR_HOME}/device/<target_path>"}, {"DOWNLOADTYPE [type_id]", "Display contents of the file defining type <type_id>."}, {"VALIDATE [type_id]", "Validate device type identified by <type_id>."}};
    public static final String[][] SECOND_LEVEL_COMMAND = new String[][]{{"ADD [ip] [netmask] [port] <state> <community> <write_community>", "Add new devices. [ip] and [port] could have mixed range format ('-'range, ',' list).\n<state> is optional and has one of values {RUNNING|STOPPED|DISABLED}.\n<community> is optional and allows to specify a read-only community string for device, different from the default one.\n<write_community> is optional and allows to specify a write community string for device, different from the default one."}, {"BACK", "Back to type mode."}, {"REMOVE [device_id]", "Remove device identified by [device_id]."}, {"START [device_id]", "Start simulation of device identified by [device_id]."}, {"STOP [device_id]", "Stop simulation of device identified by [device_id]."}, {"REPLACETYPE [source_path]", "Replace type file of current type with file defined by <source_path>."}, {"UPDATEOID [oid], [newvalue]", "Replace value returned for given oid"}};

    private HelpPrinter() {
    }

    public static String getHelpTable() {
        int i;
        int i2;
        int maxLength = 0;
        for (i2 = 0; i2 < UNIVERSAL_COMMAND.length; ++i2) {
            maxLength = Math.max(maxLength, UNIVERSAL_COMMAND[i2][0].length());
        }
        for (i2 = 0; i2 < FIRST_LEVEL_COMMAND.length; ++i2) {
            maxLength = Math.max(maxLength, FIRST_LEVEL_COMMAND[i2][0].length());
        }
        for (i2 = 0; i2 < SECOND_LEVEL_COMMAND.length; ++i2) {
            maxLength = Math.max(maxLength, SECOND_LEVEL_COMMAND[i2][0].length());
        }
        maxLength = Math.min(maxLength, 22);
        StringBuilder help = new StringBuilder();
        help.append("Commands available in each mode:\n");
        for (i = 0; i < UNIVERSAL_COMMAND.length; ++i) {
            help.append(HelpPrinter.getFormatedHelpRow(UNIVERSAL_COMMAND[i], maxLength, " - "));
        }
        help.append("\nCommands available in type mode:\n");
        for (i = 0; i < FIRST_LEVEL_COMMAND.length; ++i) {
            help.append(HelpPrinter.getFormatedHelpRow(FIRST_LEVEL_COMMAND[i], maxLength, " - "));
        }
        help.append("\nCommands available in device mode:\n");
        for (i = 0; i < SECOND_LEVEL_COMMAND.length; ++i) {
            help.append(HelpPrinter.getFormatedHelpRow(SECOND_LEVEL_COMMAND[i], maxLength, " - "));
        }
        return help.toString();
    }

    public static String getFormatedHelpRow(String[] row, int cmdWidth, String separator) {
        int i;
        StringBuilder result = new StringBuilder();
        result.append(row[0]);
        String[] descr = row[1].split("\\.");
        int missChar = cmdWidth - result.length();
        for (i = 0; i < missChar; ++i) {
            result.append(' ');
        }
        result.append(separator);
        result.append(descr[0].trim());
        result.append(".\n");
        for (i = 1; i < descr.length; ++i) {
            for (int j = 0; j < cmdWidth + separator.length(); ++j) {
                result.append(' ');
            }
            result.append(descr[i].trim());
            result.append(".\n");
        }
        return result.toString();
    }

    public static void printType(OutputPrinter printer, TypeDTO type) {
        printer.print("=================================================================");
        printer.print(type.getId() + " : " + type.getPath());
        printer.print("=================================================================");
        printer.print(String.format("%-10s %-15s %-7s %-5s %-10s %s", "Dev Id", "IP Address", "Netmask", "Port", "STATE", "Interface IPs"));
        printer.print("-----------------------------------------------------------------");
        List<DeviceDTO> devices = type.getDevices();
        Collections.sort(devices, new Comparator<DeviceDTO>(){

            @Override
            public int compare(DeviceDTO o1, DeviceDTO o2) {
                if (!o1.getAddress().equals(o2.getAddress())) {
                    return o1.getAddress().compareTo(o2.getAddress());
                }
                Integer i1 = Integer.parseInt(o1.getPort());
                Integer i2 = Integer.parseInt(o2.getPort());
                return i1.compareTo(i2);
            }
        });
        for (DeviceDTO device : devices) {
            String[] intIP = device.getAvailableInterfaces().split(",");
            if (intIP == null || intIP.length < 1) {
                intIP = new String[]{""};
            }
            printer.print(String.format("%-10d %-15s %-7s %-5s %-10s %s", device.getId(), device.getAddress(), device.getNetmask(), device.getPort(), device.getState(), intIP[0]));
            for (int j = 1; j < intIP.length; ++j) {
                printer.print(String.format("%-51s %s", "", intIP[j].trim()));
            }
        }
    }

    public static void printTypeSummary(OutputPrinter printer, TypeDTO type) {
        List<DeviceDTO> devices = type.getDevices();
        Integer[] summary = new Integer[]{0, 0, 0, 0, 0, 0};
        for (DeviceDTO device : devices) {
            Integer n;
            Integer n2;
            int n3;
            Integer[] integerArray;
            String state = device.getState();
            if (state.equals("Initialized")) {
                integerArray = summary;
                n3 = 0;
                n2 = integerArray[n3];
                n = integerArray[n3] = Integer.valueOf(integerArray[n3] + 1);
                continue;
            }
            if (state.equals("Ready")) {
                integerArray = summary;
                n3 = 1;
                n2 = integerArray[n3];
                n = integerArray[n3] = Integer.valueOf(integerArray[n3] + 1);
                continue;
            }
            if (state.equals("Finished")) {
                integerArray = summary;
                n3 = 2;
                n2 = integerArray[n3];
                n = integerArray[n3] = Integer.valueOf(integerArray[n3] + 1);
                continue;
            }
            if (state.equals("Running")) {
                integerArray = summary;
                n3 = 3;
                n2 = integerArray[n3];
                n = integerArray[n3] = Integer.valueOf(integerArray[n3] + 1);
                continue;
            }
            if (state.equals("Stopped")) {
                integerArray = summary;
                n3 = 4;
                n2 = integerArray[n3];
                n = integerArray[n3] = Integer.valueOf(integerArray[n3] + 1);
                continue;
            }
            if (state.equals("Unknown")) {
                integerArray = summary;
                n3 = 5;
                n2 = integerArray[n3];
                n = integerArray[n3] = Integer.valueOf(integerArray[n3] + 1);
                continue;
            }
            integerArray = summary;
            n3 = 5;
            n2 = integerArray[n3];
            n = integerArray[n3] = Integer.valueOf(integerArray[n3] + 1);
        }
        printer.print(String.format("%-10d %-5d %-5d %-5d %-5d %-5d %-5d %-5d %s", type.getId(), devices.size(), summary[0], summary[1], summary[2], summary[3], summary[4], summary[5], type.getPath()));
    }

    public static void printAvailableDevices(OutputPrinter printer, List<String> typeFiles) {
        printer.print("Available types:\n");
        printer.print("=================================================================");
        for (String type : typeFiles) {
            printer.print(type);
        }
    }
}

