/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.client.main;

import com.veraxsystems.simulatorSNMP.rmi.client.console.RmiConsole;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.ConsolePrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.console.parser.OutputPrinter;
import com.veraxsystems.simulatorSNMP.rmi.client.main.MyOptions;
import com.veraxsystems.simulatorSNMP.rmi.client.versioning.Version;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.apache.log4j.Logger;

public final class Main {
    private static final Parser PARSER = new GnuParser();
    private static CommandLine cmd;
    private static Logger logger;
    private static OutputPrinter printer;

    private Main() {
    }

    public static void main(String[] args) {
        try {
            cmd = PARSER.parse(new MyOptions(), args);
        }
        catch (ParseException e1) {
            printer.printError(e1.getMessage());
        }
        String host = "127.0.0.1";
        Integer port = 43500;
        if (cmd instanceof CommandLine) {
            host = cmd.getOptionValue('h', "127.0.0.1");
            port = Integer.parseInt(cmd.getOptionValue('p', Integer.toString(43500)));
        }
        if (cmd.hasOption('s')) {
            Main.checkState(host, port);
        } else if (cmd instanceof CommandLine && cmd.hasOption('c')) {
            Main.processBatch(host, port);
        } else {
            Main.processInteractive();
        }
    }

    private static void processInteractive() {
        Scanner in = new Scanner(System.in);
        printer.print("Welcome to Verax SNMP Simulator v." + Version.getVersionString() + ". Copyright (c) Verax Systems. All rights reserved.");
        String serverAdr = "127.0.0.1";
        Integer serverPort = 43500;
        printer.print("Do you want to connect to default simulator server? [Y/n]", false);
        String defConnection = in.nextLine();
        if (!defConnection.isEmpty() && !defConnection.equalsIgnoreCase("y")) {
            printer.print("IP address[127.0.0.1]:", false);
            String defAddr = in.nextLine();
            if (!defAddr.isEmpty()) {
                serverAdr = defAddr;
            }
            printer.print("Port[43500]:", false);
            String defPort = in.nextLine();
            if (!defPort.isEmpty()) {
                try {
                    serverPort = Integer.parseInt(defPort);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        Main.doExecute(in, serverAdr, serverPort);
    }

    private static void doExecute(Scanner in, String serverAdr, Integer serverPort) {
        printer.print("Connecting to " + serverAdr + ":" + serverPort);
        String[] input = null;
        try {
            RmiConsole rmi = new RmiConsole(serverAdr, serverPort);
            printer.print(rmi.getWelcome());
            while ((input = Main.processCommand(in, rmi)).length == 0 || !input[0].toUpperCase().startsWith("END") && !input[0].toUpperCase().startsWith("EXIT") && !input[0].toUpperCase().startsWith("FINISH")) {
            }
        }
        catch (RemoteException e) {
            printer.printError("Connection error");
        }
        catch (NotBoundException e) {
            printer.printError("Service not found");
        }
    }

    private static String[] processCommand(Scanner in, RmiConsole rmi) throws RemoteException {
        String prefix = "";
        int currType = rmi.getState().getId();
        if (currType != -1) {
            prefix = prefix + currType;
        }
        prefix = prefix + "\\>";
        printer.print(prefix, false);
        String[] input = rmi.readInput(in).split(" ");
        if (input.length > 0) {
            try {
                rmi.runCmd(input[0].toUpperCase(), input.length > 1 ? Arrays.copyOfRange(input, 1, input.length) : null);
            }
            catch (IOException e) {
                printer.printError("Error processing command: " + e.getMessage());
            }
        }
        return input;
    }

    private static void processBatch(String host, Integer port) {
        String command = cmd.getOptionValue('c');
        String params = cmd.getOptionValue('a', "");
        try {
            RmiConsole rmi = new RmiConsole(host, port);
            if (cmd.hasOption('t')) {
                String tId = cmd.getOptionValue('t', "0");
                rmi.runCmd("SELECT", new String[]{tId});
            }
            rmi.runCmd(command, params.split(" "));
        }
        catch (RemoteException e) {
            printer.printError("Connection error.");
        }
        catch (NotBoundException e) {
            printer.printError("Service not found.");
        }
        catch (IOException e) {
            printer.printError("Error processing command: " + e.getMessage());
        }
    }

    private static void checkState(String host, Integer port) {
        try {
            new RmiConsole(host, port);
            printer.print("Verax SNMP Simulator is running.");
        }
        catch (RemoteException e) {
            printer.print("Verax SNMP Simulator stopped.");
        }
        catch (NotBoundException e) {
            printer.print("Verax SNMP Simulator stopped.");
        }
    }

    static {
        logger = Logger.getLogger(Main.class);
        printer = new ConsolePrinter(System.out, System.err);
    }
}

