/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons;

import com.veraxsystems.commons.updater.DatabaseWrapper;
import com.veraxsystems.commons.updater.TaskLoader;
import com.veraxsystems.commons.updater.factory.AbstractTaskFactory;
import com.veraxsystems.commons.updater.factory.BasicTaskFactory;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.io.File;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Updater
implements InitializingBean,
ApplicationContextAware {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected String hibernateProperties;
    protected boolean useAnnotationConifguration = true;
    protected String configLocation;
    protected String updateDir = "vx_application_updates";
    protected AbstractTaskFactory factory = new BasicTaskFactory();
    protected ApplicationContext applicationContext;
    protected static String defaultSchemaKey = "hibernate.default_schema";

    public void executeSchemaUpdate(String cfgFile, String hibProps) {
        try {
            this.logger.info("starting hibernate schema update");
            Object cfg = null;
            cfg = this.useAnnotationConifguration ? new AnnotationConfiguration() : new Configuration();
            boolean script = this.logger.isDebugEnabled();
            boolean doUpdate = true;
            cfg.configure(cfgFile);
            if (hibProps != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load((InputStream)new StringInputStream(this.hibernateProperties));
                cfg.setProperties(props);
            }
            if (cfg.getProperties().containsKey(defaultSchemaKey) && cfg.getProperties().getProperty(defaultSchemaKey).isEmpty()) {
                cfg.getProperties().remove(defaultSchemaKey);
            }
            new SchemaUpdate((Configuration)cfg).execute(script, doUpdate);
            this.logger.info("hibernate schema update done.");
        }
        catch (Throwable e) {
            System.err.println("Error running schema update" + e);
            this.logger.error("Error running schema update", e);
        }
    }

    public void executeUpdate() throws Exception {
        this.logger.info("launching Verax Updater");
        this.logger.info("using config file: " + this.configLocation);
        this.logger.info("using properties: ");
        this.displayProperties(this.hibernateProperties);
        DatabaseWrapper db = new DatabaseWrapper(this.hibernateProperties);
        Collection<AbstractTask> tasks = this.getUpdateTasks(db);
        if (!tasks.isEmpty()) {
            this.executeSchemaUpdate(this.configLocation, this.hibernateProperties);
            for (AbstractTask task : tasks) {
                try {
                    task.registerProperty("hibernateProperties", this.hibernateProperties);
                    if (task instanceof ApplicationContextAware) {
                        ((ApplicationContextAware)task).setApplicationContext(this.applicationContext);
                    }
                    task.process(db.getConnection());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            this.logger.info("task execution complete");
            db.saveTasksToDb(tasks);
            this.logger.info("results saved to DB, all work completed");
        } else {
            this.logger.info("no tasks to run");
        }
    }

    protected Collection<AbstractTask> getUpdateTasks(DatabaseWrapper db) throws Exception {
        TaskLoader loader = new TaskLoader();
        List<File> files = loader.getUpdateFiles(this.updateDir);
        List<AbstractTask> tasks = loader.getUpdateTasks(files, this.factory);
        this.logger.info(tasks.size() + " tasks loaded");
        Collections.sort(tasks);
        db.evictOldTasks(tasks);
        this.logger.info(tasks.size() + " tasks remaining after evictOldTasks");
        return tasks;
    }

    public void afterPropertiesSet() throws Exception {
        this.executeUpdate();
    }

    public void setHibernateProperties(String hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public void setFactory(AbstractTaskFactory factory) {
        this.factory = factory;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setUseAnnotationConifguration(boolean value) {
        this.useAnnotationConifguration = value;
    }

    public void setApplicationUpdatesDirectory(String applicationUpdatesDirectory) {
        this.updateDir = applicationUpdatesDirectory;
    }

    protected void displayProperties(String properties) throws Exception {
        Properties props = new Properties();
        props.load((InputStream)new StringInputStream(properties));
        for (Object key : props.keySet()) {
            if ("hibernate.connection.password".equals(key.toString())) {
                this.logger.info(key + " = *************");
                continue;
            }
            this.logger.info(key + " = " + props.get(key));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

