/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license;

import com.veraxsystems.commons.license.LicenseUtils;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public final class HardwareLicenseManager
extends LicenseManager {
    public static final String LICENSE_HEADER = "--------------LICENSE----------------";
    public static final String LICENSE_FOOTER = "-----------END OF LICENSE------------";
    public static final String LICENSE_REQUEST_HEADER = "--------------LICENSE REQUEST----------------";
    public static final String LICENSE_REQUEST_FOOTER = "----------END OF LICENSE REQUEST-------------";

    @Override
    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        block5: {
            super.validate(content);
            try {
                Properties properties = (Properties)content.getExtra();
                if (properties != null) {
                    String hrdwrAddresses = properties.getProperty(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES);
                    if (!hrdwrAddresses.equals(LicenseUtils.getHardwareSignature())) {
                        throw new LicenseContentException(LicenseUtils.EX_HDWADDR_INVALID);
                    }
                    break block5;
                }
                throw new LicenseContentException(LicenseUtils.EX_LICENSE_INVALID);
            }
            catch (LicenseContentException lce) {
                throw lce;
            }
            catch (Throwable t) {
                throw new LicenseContentException(LicenseUtils.EX_LICENSE_INVALID);
            }
        }
    }

    public Properties getProperties() throws LicenseContentException {
        Properties result = null;
        try {
            result = (Properties)this.verify().getExtra();
        }
        catch (Throwable t) {
            throw new LicenseContentException(LicenseUtils.EX_LICENSE_INVALID);
        }
        return result;
    }

    public boolean install(String licenseText) {
        boolean result = false;
        if (licenseText != null) {
            if ((licenseText = LicenseUtils.formatLicenseText(licenseText, false)).substring(0, LICENSE_HEADER.length()).equals(LICENSE_HEADER)) {
                licenseText = licenseText.substring(LICENSE_HEADER.length());
            }
            if (licenseText.substring(licenseText.length() - LICENSE_FOOTER.length()).equals(LICENSE_FOOTER)) {
                licenseText = licenseText.substring(0, licenseText.length() - LICENSE_FOOTER.length());
            }
            byte[] license = Base64.decodeBase64(licenseText.getBytes());
            try {
                this.install(license, this.getLicenseNotary());
                result = true;
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).error(t.getMessage());
                result = false;
            }
        }
        return result;
    }
}

