/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license;

import com.veraxsystems.commons.license.LicenseParamImpl;
import com.veraxsystems.commons.license.LicenseRequest;
import com.veraxsystems.commons.license.LicenseUtils;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.util.ObfuscatedString;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;

public class LicenseGenerator {
    private Properties properties;
    private LicenseRequest request;
    private LicenseManager manager;
    private boolean embedLicenseContent;

    public LicenseGenerator(LicenseRequest request, Properties properties) {
        this.request = request;
        this.properties = properties;
        this.manager = new LicenseManager(this.getLicenseParam(properties));
    }

    public LicenseGenerator(LicenseRequest request, Properties properties, boolean embedLicenseContent) {
        this.request = request;
        this.properties = properties;
        this.manager = new LicenseManager(this.getLicenseParam(properties));
        this.embedLicenseContent = embedLicenseContent;
    }

    public String generate() {
        assert (this.request != null);
        assert (this.properties != null);
        String result = null;
        try {
            LicenseContent licenseContent = this.generateLicenseContent();
            byte[] license = this.manager.create(licenseContent);
            result = LicenseUtils.storeAsBase64(license);
            String decorated = "--------------LICENSE----------------\n";
            decorated = decorated + LicenseUtils.formatLicenseText(result, true);
            result = decorated = decorated + "-----------END OF LICENSE------------";
        }
        catch (Throwable t) {
            System.err.println(LicenseUtils.EX_GENERATING);
            t.printStackTrace();
        }
        return result;
    }

    public void showLicense() {
        assert (this.request != null);
        assert (this.properties != null);
        System.out.println(this.generate());
    }

    public String makeLicenseForOss() {
        assert (this.request != null);
        assert (this.properties != null);
        String licenseContent = this.generate();
        Properties merged = this.getMergedProperties();
        StringBuilder sb = new StringBuilder();
        sb.append("feature=" + merged.getProperty("LICENSE_CONTENT_FEATURE"));
        sb.append("\ncount=" + merged.getProperty("LICENSE_CONTENT_COUNT"));
        sb.append("\nguid=" + merged.getProperty("LICENSE_CONTENT_GUID"));
        sb.append("\nhardwareID=" + merged.getProperty("LICENSE_CONTENT_HARDWARE_ID"));
        sb.append("\nexpiry_date=" + merged.getProperty("LICENSE_CONTENT_EXPIRY_DATE"));
        sb.append("\ndescription=" + merged.getProperty("LICENSE_CONTENT_DESCRIPTION"));
        if (merged.containsKey("LICENSE_CONTENT_VERSION")) {
            sb.append("\nversion=" + merged.getProperty("LICENSE_CONTENT_VERSION"));
        }
        sb.append("\nlicense_content=" + licenseContent.replace("\n", "\\\n"));
        return sb.toString();
    }

    public void showLicenseProperties() {
        assert (this.request != null);
        assert (this.properties != null);
        Properties output = new Properties();
        Properties merged = this.getMergedProperties();
        output.setProperty(LicenseUtils.PROPERTY_HOLDER, merged.getProperty(LicenseUtils.PROPERTY_HOLDER));
        output.setProperty(LicenseUtils.PROPERTY_ISSUER, merged.getProperty(LicenseUtils.PROPERTY_ISSUER));
        output.setProperty(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES, merged.getProperty(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES));
        output.putAll((Map<?, ?>)this.extractLimits(merged));
        this.showProperties(output, "LicenseProperties");
    }

    public void showTemplateProperties() {
        assert (this.properties != null);
        this.showProperties(this.properties, "Template properties");
    }

    public void showRequest() {
        assert (this.request != null);
        try {
            System.out.println(this.request.getEncrypted());
        }
        catch (Throwable t) {
            System.err.println("Problem in processing request");
        }
    }

    public void showRequestProperties() {
        assert (this.request != null);
        try {
            this.showProperties(this.request.getProperties(), "Request properties");
        }
        catch (Throwable t) {
            System.err.println("Problem in processing request");
        }
    }

    private void showProperties(Properties properties, String header) {
        try {
            properties.store(System.out, header);
        }
        catch (IOException e) {
            System.err.println("Problem in showing properties");
        }
    }

    public void generateClientSecurityCode() {
        assert (this.properties != null);
        StringBuffer sb = new StringBuffer();
        sb.append("String a = ").append(ObfuscatedString.obfuscate(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_CIPHER))).append(";\n");
        sb.append("String b = ").append(ObfuscatedString.obfuscate(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE_ALIAS))).append(";\n");
        sb.append("String c = ").append(ObfuscatedString.obfuscate(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE_PASS))).append(";\n");
        sb.append("String d = ").append(ObfuscatedString.obfuscate(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE))).append(";\n");
        sb.append("String e = ").append(ObfuscatedString.obfuscate(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT))).append(";\n");
        sb.append("LicenseParam lp = new LicenseParamImpl(a,b,null,c,d,e,<CLAZZ>);\n");
        System.out.println(sb);
    }

    private X500Principal getSubject() {
        assert (this.properties != null);
        StringBuffer content = new StringBuffer();
        content.append(LicenseUtils.X500_CN).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT_CN));
        content.append(LicenseUtils.X500_OU).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT_OU));
        content.append(LicenseUtils.X500_O).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT_O));
        content.append(LicenseUtils.X500_L).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT_L));
        content.append(LicenseUtils.X500_ST).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT_ST));
        content.append(LicenseUtils.X500_C).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT_C));
        return new X500Principal(content.toString());
    }

    private X500Principal getIssuer() {
        assert (this.properties != null);
        StringBuffer content = new StringBuffer();
        content.append(LicenseUtils.X500_CN).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ISSUER_CN));
        content.append(LicenseUtils.X500_OU).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ISSUER_OU));
        content.append(LicenseUtils.X500_O).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ISSUER_O));
        content.append(LicenseUtils.X500_L).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ISSUER_L));
        content.append(LicenseUtils.X500_ST).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ISSUER_ST));
        content.append(LicenseUtils.X500_C).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ISSUER_C));
        return new X500Principal(content.toString());
    }

    private X500Principal getTrialSubject() {
        assert (this.properties != null);
        StringBuffer content = new StringBuffer();
        content.append(LicenseUtils.X500_CN).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_CN));
        content.append(LicenseUtils.X500_OU).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_OU));
        content.append(LicenseUtils.X500_O).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_O));
        content.append(LicenseUtils.X500_L).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_L));
        content.append(LicenseUtils.X500_ST).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_ST));
        content.append(LicenseUtils.X500_C).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_C));
        return new X500Principal(content.toString());
    }

    private X500Principal getTrialIssuer() {
        assert (this.properties != null);
        StringBuffer content = new StringBuffer();
        content.append(LicenseUtils.X500_CN).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_CN));
        content.append(LicenseUtils.X500_OU).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_OU));
        content.append(LicenseUtils.X500_O).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_O));
        content.append(LicenseUtils.X500_L).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_L));
        content.append(LicenseUtils.X500_ST).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_ST));
        content.append(LicenseUtils.X500_C).append(LicenseUtils.EQUAL).append(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_C));
        return new X500Principal(content.toString());
    }

    public void generateTrialKeyStore() {
        assert (this.properties != null);
        try {
            X500Principal subject = this.getTrialSubject();
            X500Principal issuer = this.getTrialIssuer();
            Calendar notBefore = Calendar.getInstance();
            Calendar notAfter = (Calendar)notBefore.clone();
            notBefore.add(5, -1);
            notAfter.add(1, 10);
            KeyStore secretKeyStore = LicenseUtils.createSecretKeystore(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_KEYSTORE_ALIAS), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_KEY_PASS), subject, issuer, notBefore.getTime(), notAfter.getTime(), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ALGORITHM), Integer.parseInt(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEY_LENGTH)), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_TYPE));
            File secretKestoreFile = new File(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_DIR) + this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_KEYSTORE));
            FileOutputStream secretStream = new FileOutputStream(secretKestoreFile);
            secretKeyStore.store(secretStream, this.properties.getProperty(LicenseUtils.PROPERTY_SEC_TRIAL_KEYSTORE_PASS).toCharArray());
            secretStream.flush();
            secretStream.close();
        }
        catch (Throwable t) {
            System.err.println("Error during generating trial keystore:");
            t.printStackTrace();
        }
    }

    public void generateKeyStorePair() {
        assert (this.properties != null);
        try {
            X500Principal subject = this.getSubject();
            X500Principal issuer = this.getIssuer();
            Calendar notBefore = Calendar.getInstance();
            Calendar notAfter = (Calendar)notBefore.clone();
            notBefore.add(5, -1);
            notAfter.add(1, 10);
            KeyStore secretKeyStore = LicenseUtils.createSecretKeystore(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_ALIAS), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEY_PASS), subject, issuer, notBefore.getTime(), notAfter.getTime(), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_ALGORITHM), Integer.parseInt(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEY_LENGTH)), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_TYPE));
            KeyStore publicKeyStore = LicenseUtils.exportPublicKeystore(secretKeyStore, this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_ALIAS), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE_ALIAS), this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_TYPE));
            File secretKestoreFile = new File(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_DIR) + this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE));
            FileOutputStream secretStream = new FileOutputStream(secretKestoreFile);
            secretKeyStore.store(secretStream, this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_PASS).toCharArray());
            secretStream.flush();
            secretStream.close();
            File publicKestoreFile = new File(this.properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_DIR) + this.properties.getProperty(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE));
            FileOutputStream publicStream = new FileOutputStream(publicKestoreFile);
            publicKeyStore.store(publicStream, this.properties.getProperty(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE_PASS).toCharArray());
            publicStream.flush();
            publicStream.close();
        }
        catch (Throwable t) {
            System.err.println("Error during generating keystore pair:");
            t.printStackTrace();
        }
    }

    private LicenseParam getLicenseParam(Properties properties) {
        String cipherPassword = properties.getProperty(LicenseUtils.PROPERTY_SEC_CIPHER);
        String keystoreAlias = properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_ALIAS);
        String keyPassword = properties.getProperty(LicenseUtils.PROPERTY_SEC_KEY_PASS);
        String keyStorePassword = properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE_PASS);
        String keyStore = properties.getProperty(LicenseUtils.PROPERTY_SEC_KEYSTORE);
        String subject = properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT);
        Class<LicenseGenerator> clazz = LicenseGenerator.class;
        return new LicenseParamImpl(cipherPassword, keystoreAlias, keyPassword, keyStorePassword, keyStore, subject, clazz);
    }

    private Properties getMergedProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        try {
            result.putAll((Map<?, ?>)this.request.getProperties());
        }
        catch (Throwable e) {
            System.err.println("Error fetching properties from request");
        }
        return result;
    }

    private void validateRequestProperties(Properties requestProperties) throws SecurityException {
        if (requestProperties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT) != null && !requestProperties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT).trim().equals("")) {
            String subjectAtServer = this.properties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT);
            if (!requestProperties.getProperty(LicenseUtils.PROPERTY_SEC_SUBJECT).equals(subjectAtServer)) {
                throw new SecurityException("Subject set on server properties file does not match the one sent in request");
            }
        } else {
            throw new SecurityException("Subject has to be set in the request");
        }
        Properties limitProperties = this.extractLimits(requestProperties);
        if (limitProperties.size() > 0) {
            throw new SecurityException("Limit properties cannot be set in the request");
        }
    }

    private void validateMergedProperties(Properties mergedProperties) throws SecurityException {
        for (String key : this.properties.stringPropertyNames()) {
            if (mergedProperties.getProperty(key) != null && !mergedProperties.getProperty(key).trim().equals("")) continue;
            throw new SecurityException("Not all needed license properties are populated: " + key);
        }
    }

    private Properties extractLimits(Properties properties) {
        Properties result = new Properties();
        for (String key : properties.stringPropertyNames()) {
            if (key.matches("^LIMIT_.*")) {
                result.setProperty(key, properties.getProperty(key));
                continue;
            }
            if (!this.embedLicenseContent || !key.matches("^LICENSE_CONTENT_.*")) continue;
            result.setProperty(key, properties.getProperty(key));
        }
        return result;
    }

    private LicenseContent generateLicenseContent() throws SecurityException {
        assert (this.properties.getProperty(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES) == null || this.properties.getProperty(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES).trim().equals(""));
        assert (this.request != null);
        LicenseContent result = new LicenseContent();
        try {
            this.validateRequestProperties(this.request.getProperties());
            Properties merged = this.getMergedProperties();
            this.validateMergedProperties(merged);
            X500Principal holder = new X500Principal("CN=" + merged.getProperty(LicenseUtils.PROPERTY_HOLDER));
            result.setHolder(holder);
            X500Principal issuer = new X500Principal("CN=" + merged.getProperty(LicenseUtils.PROPERTY_ISSUER));
            result.setIssuer(issuer);
            result.setConsumerAmount(1);
            result.setConsumerType("User");
            result.setIssued(new Date());
            result.setInfo(LicenseUtils.COMMERCIAL_LICENSE);
            Properties extraProperties = this.extractLimits(merged);
            extraProperties.setProperty(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES, merged.getProperty(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES));
            result.setExtra(extraProperties);
        }
        catch (Throwable t) {
            throw new SecurityException("Generating license content failed");
        }
        return result;
    }

    private static void showCommandLineHelp() {
        System.err.println("Bad parameters!\nCorrect are: <program> -p <properties_file> -r <request_file> -c <command>");
        System.err.println("Commands: g  (generate license)");
        System.err.println("Commands: go (generate license for oss/bss)");
        System.err.println("          lp (show license properties)");
        System.err.println("          r  (show request)");
        System.err.println("          rp (show request properties)");
        System.err.println("          tp (show template properties)");
        System.err.println("          gkp (generate keystore pair for commercial license)");
        System.err.println("          gtk (generate trial keystore)");
        System.err.println("          gks (generate keystore for signing)");
        System.err.println("          gsp (generate signing parameters)");
        System.err.println("          gst (generate security token");
        System.err.println("          gs (generate code with security statics for LicenseParam)");
    }

    private static void validateCommandLine(String[] args) {
        if (args.length != 6) {
            LicenseGenerator.showCommandLineHelp();
            System.exit(0);
        }
        if (!args[0].equals("-p")) {
            LicenseGenerator.showCommandLineHelp();
            System.exit(0);
        }
        if (!args[2].equals("-r")) {
            LicenseGenerator.showCommandLineHelp();
            System.exit(0);
        }
        if (!args[4].equals("-c")) {
            LicenseGenerator.showCommandLineHelp();
            System.exit(0);
        }
    }

    private static Command validateCommand(String command) {
        Command result = null;
        try {
            result = Command.valueOf(command);
        }
        catch (Throwable t) {
            LicenseGenerator.showCommandLineHelp();
            System.exit(0);
        }
        return result;
    }

    private static Properties validateProperties(String propertiesFile) {
        Properties result = new Properties();
        try {
            result.load(new FileInputStream(propertiesFile));
        }
        catch (Throwable t) {
            System.err.println("Problem in reading properties file");
            System.exit(0);
        }
        return result;
    }

    private static String validateRequest(String requestFile) {
        StringBuffer result = new StringBuffer();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(requestFile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                result.append(strLine).append("\n");
            }
            in.close();
        }
        catch (Throwable t) {
            System.err.println("Problem in reading request file");
            System.exit(0);
        }
        return result.toString();
    }

    public static void obfuscateLicenseUtilsStatics() {
        System.out.println("public static final String PROPERTY_SEC_CIPHER = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_CIPHER));
        System.out.println("public static final String PROPERTY_SEC_KEYSTORE_ALIAS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_KEYSTORE_ALIAS));
        System.out.println("public static final String PROPERTY_SEC_KEY_PASS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_KEY_PASS));
        System.out.println("public static final String PROPERTY_SEC_KEYSTORE_PASS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_KEYSTORE_PASS));
        System.out.println("public static final String PROPERTY_SEC_KEYSTORE = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_KEYSTORE));
        System.out.println("public static final String PROPERTY_SEC_SUBJECT = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_SUBJECT));
        System.out.println("public static final String PROPERTY_SEC_HARDWARE_ADDRESSES = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_HARDWARE_ADDRESSES));
        System.out.println("public static final String PROPERTY_SEC_PUBLIC_KEYSTORE_ALIAS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE_ALIAS));
        System.out.println("public static final String PROPERTY_SEC_PUBLIC_KEYSTORE_PASS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE_PASS));
        System.out.println("public static final String PROPERTY_SEC_PUBLIC_KEYSTORE = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_PUBLIC_KEYSTORE));
        System.out.println("public static final String PROPERTY_SEC_ALGORITHM = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_ALGORITHM));
        System.out.println("public static final String PROPERTY_SEC_KEY_LENGTH = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_KEY_LENGTH));
        System.out.println("public static final String PROPERTY_SEC_KEYSTORE_TYPE = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_KEYSTORE_TYPE));
        System.out.println("public static final String PROPERTY_SEC_KEYSTORE_DIR = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_KEYSTORE_DIR));
        System.out.println("public static final String PROPERTY_SEC_ISSUER_CN = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_ISSUER_CN));
        System.out.println("public static final String PROPERTY_SEC_ISSUER_OU = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_ISSUER_OU));
        System.out.println("public static final String PROPERTY_SEC_ISSUER_O = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_ISSUER_O));
        System.out.println("public static final String PROPERTY_SEC_ISSUER_L = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_ISSUER_L));
        System.out.println("public static final String PROPERTY_SEC_ISSUER_ST = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_ISSUER_ST));
        System.out.println("public static final String PROPERTY_SEC_ISSUER_C = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_ISSUER_C));
        System.out.println("public static final String PROPERTY_SEC_SUBJECT_CN = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_SUBJECT_CN));
        System.out.println("public static final String PROPERTY_SEC_SUBJECT_OU = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_SUBJECT_OU));
        System.out.println("public static final String PROPERTY_SEC_SUBJECT_O = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_SUBJECT_O));
        System.out.println("public static final String PROPERTY_SEC_SUBJECT_L = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_SUBJECT_L));
        System.out.println("public static final String PROPERTY_SEC_SUBJECT_ST = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_SUBJECT_ST));
        System.out.println("public static final String PROPERTY_SEC_SUBJECT_C = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_SUBJECT_C));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_KEYSTORE_ALIAS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_KEYSTORE_ALIAS));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_KEYSTORE_PASS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_KEYSTORE_PASS));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_KEY_PASS = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_KEY_PASS));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_KEYSTORE = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_KEYSTORE));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_ISSUER_CN = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_CN));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_ISSUER_OU = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_OU));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_ISSUER_O = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_O));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_ISSUER_L = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_L));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_ISSUER_ST = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_ST));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_ISSUER_C = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_ISSUER_C));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_SUBJECT_CN = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_CN));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_SUBJECT_OU = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_OU));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_SUBJECT_O = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_O));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_SUBJECT_L = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_L));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_SUBJECT_ST = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_ST));
        System.out.println("public static final String PROPERTY_SEC_TRIAL_SUBJECT_C = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_SEC_TRIAL_SUBJECT_C));
        System.out.println("public static final String X500_CN = " + ObfuscatedString.obfuscate(LicenseUtils.X500_CN));
        System.out.println("public static final String X500_OU = " + ObfuscatedString.obfuscate(LicenseUtils.X500_OU));
        System.out.println("public static final String X500_O = " + ObfuscatedString.obfuscate(LicenseUtils.X500_O));
        System.out.println("public static final String X500_L = " + ObfuscatedString.obfuscate(LicenseUtils.X500_L));
        System.out.println("public static final String X500_ST = " + ObfuscatedString.obfuscate(LicenseUtils.X500_ST));
        System.out.println("public static final String X500_C = " + ObfuscatedString.obfuscate(LicenseUtils.X500_C));
        System.out.println("public static final String PROPERTY_HOLDER = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_HOLDER));
        System.out.println("public static final String PROPERTY_ISSUER = " + ObfuscatedString.obfuscate(LicenseUtils.PROPERTY_ISSUER));
        System.out.println("public static final String EQUAL = " + ObfuscatedString.obfuscate(LicenseUtils.EQUAL));
        System.out.println("public static final String TRIAL_LICENSE = " + ObfuscatedString.obfuscate(LicenseUtils.TRIAL_LICENSE));
        System.out.println("public static final String COMMERCIAL_LICENSE = " + ObfuscatedString.obfuscate(LicenseUtils.COMMERCIAL_LICENSE));
        System.out.println("public static final String TRIAL_INSTALLED = " + ObfuscatedString.obfuscate(LicenseUtils.TRIAL_INSTALLED));
        System.out.println("public static final String TRIAL_HOLDER = " + ObfuscatedString.obfuscate(LicenseUtils.TRIAL_HOLDER));
        System.out.println("public static final String TRIAL_ISSUER = " + ObfuscatedString.obfuscate(LicenseUtils.TRIAL_ISSUER));
        System.out.println("public static final String EX_GENERATING = " + ObfuscatedString.obfuscate(LicenseUtils.EX_GENERATING));
        System.out.println("public static final String EX_HDWADDR_INVALID = " + ObfuscatedString.obfuscate(LicenseUtils.EX_HDWADDR_INVALID));
        System.out.println("public static final String EX_LICENSE_INVALID = " + ObfuscatedString.obfuscate(LicenseUtils.EX_LICENSE_INVALID));
        System.out.println("public static final String EX_INSTALL_FAILED = " + ObfuscatedString.obfuscate(LicenseUtils.EX_INSTALL_FAILED));
    }

    public static void main(String[] args) {
        LicenseGenerator.validateCommandLine(args);
        Properties properties = LicenseGenerator.validateProperties(args[1]);
        String requestText = LicenseGenerator.validateRequest(args[3]);
        Command command = LicenseGenerator.validateCommand(args[5]);
        LicenseRequest request = new LicenseRequest(properties.getProperty(LicenseUtils.PROPERTY_SEC_CIPHER), requestText);
        LicenseGenerator generator = new LicenseGenerator(request, properties, false);
        switch (command) {
            case g: {
                generator.embedLicenseContent = false;
                generator.showLicense();
                break;
            }
            case go: {
                generator.embedLicenseContent = true;
                System.out.println(generator.makeLicenseForOss());
                break;
            }
            case lp: {
                generator.showLicenseProperties();
                break;
            }
            case r: {
                generator.showRequest();
                break;
            }
            case rp: {
                generator.showRequestProperties();
                break;
            }
            case tp: {
                generator.showTemplateProperties();
                break;
            }
            case gs: {
                generator.generateClientSecurityCode();
                break;
            }
            case gkp: {
                generator.generateKeyStorePair();
                break;
            }
            case gtk: {
                generator.generateTrialKeyStore();
            }
        }
    }

    private static enum Command {
        g,
        go,
        lp,
        r,
        rp,
        tp,
        gs,
        gkp,
        gtk;

    }
}

