/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license;

import com.veraxsystems.commons.license.LicenseGenerator;
import com.veraxsystems.commons.license.LicenseRequest;
import com.veraxsystems.commons.license.LicenseUtils;
import com.veraxsystems.commons.updater.utils.OssBssLicense;
import com.veraxsystems.licensing.signer.Signer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;

public class LicenseGeneratorOssWrapper {
    public static String CIPHER_PASSWORD = "cipher0147Cipher";
    public static String SEC_ALGORITHM = "RSA";
    public static String SEC_KEY_LENGTH = "1024";
    public static String SEC_KEYSTORE_DIR = "keystores";
    public static String SEC_KEYSTORE_TYPE = "JKS";
    public static String SEC_KEYSTORE_ALIAS = "secureKeystore";
    public static String SEC_KEYSTORE_PASS = "keystore0";
    public static String SEC_KEY_PASS = "keystore0";
    public static String SEC_KEYSTORE = "/thePrivate.store";
    public static String SEC_PUBLIC_KEYSTORE_ALIAS = "publicKeystore";
    public static String SEC_PUBLIC_KEYSTORE = "thePublic.store";
    public static String SEC_PUBLIC_KEYSTORE_PASS = "keystore0";
    public static String LICENSE_HOLDER = "Verax Systems Sp. z.o.o.";
    public static String LICENSE_ISSUER = "Verax Systems Sp. z.o.o.";
    public static String LICENSE_SUBJECT = "OSS_BSS_LICENSE";
    public static String OSS_SIGNER_SECRET_KEY = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCz/+SSP9tnGydVKVG0N+D5EEg4L9wTZLVDReE3aN0PxCYyB7joj6xjHR2AKDCIM2OfbIUBJbAnKFXWA9u1jyt00crMepDsoiSHmoQXn2YvwSqwb0Kf5x7rLR8H4c+sBJM2WQrllKxEqjRk2gjdP+vEk48VtgfASein+yS6Ovf9ypfALChScMPauWcw/Zq1L+upoEHiDclUoS1DIB+fIGwVMr/HLvOhIGsQgxua2xBX0Z+BicejjQgdnBolIc3Pr+NSx2iVIrmbdi6fTcTBSJ0jyzDwiGp11Uu8FwimHXINaKftul6qadiZMHFBk0wav3YP5o15OvA6qjTKdjM0PgnxAgMBAAECggEBAK2Py/19V3i3BRkny2GkE+j02z5aX7HPhLzGb+C225mtQEsziQeuKcI0O9LsbceXDbOWtzUg+xb23LWNaNhLodJ1zD+Y249g1SpwQnhouebIMvqHfc2j1PtdubMm+NFcY/qep1QyJF3dZMHuP2ffj94vjmOX7ydp3M3E62grHh73C2e1DDP7GdN9svkqkCakI+xDMIvC3YenIfnRUaWgSW1gMlRcl184MNtZ7g3h5VnC2s8gkABT5EAXv6lJbhI9LtNZgr0aykwK6a/0Orj5lQSP8QzzklojCPz7yVhoM5YKqn3L3XjWMU0Im96rs6+6lCuItjEJjPc+WwZWeZkuXAECgYEA/zCWDV9NPYhYyO/qCrzMHT0ppjms0sefovgRHRxjEmEsxqdS90ACYoTUecJfmN5zSGK34hYaY97kptTDSRbxxP9qS66Bc5ROAeVucySHQG5FYIUPtIYm5zkAsIpkutJWn51bKAAC52e1P2zUVca4NoPotwUMrJTLK523vtqxqrECgYEAtJIxg2LzkZsPTpo1zxbfggTGgh+77tj8RGd1pnIv7EGquDxrdcVSlW2LAFV1VywSs0Qwi68MRLZis+uieEcvjXLeHHLgU7aTdenXbsJPyTqWuIsNHeVzXzWIxx2AdmNdkyvG7aFAiIZKfjFa++/u4JjdymxSmjl0c2dKzvtjo0ECgYBPYSur6TM7qsgDaS2iPWw4xCfKfzJVNqdfqE6agZQHyZaGDNJv+sdDIhJ99YqLINc3cw3EFCANZO43PwOoHq0CHHlSJWw7KazCRj3/LyOrVSHbjkh+XSSI1GB0ifgfbQJpECek36wHk2j727yJGhF/U7T2CWoR3Q79+EeJ5LlTYQKBgC7W3VEfkd7rQgU5q0uUu1WWt4d5g95pGscDr1kFtbirMAWqZpWeIdXxHGVxxYZfQFqQDaeuOJh6VxAkx3g7vvIKIeNvSRFuAsJLbj6k2N1x/TbRmw1uP4cq89fypygOjm9mo6twcLT5YMlrNBa2HljUTnP7tVGcJcDpwlX+j9IBAoGAYqf6LQPwDZeOc34H0B+MyV1CHCJT6qUa7Sw9FBjWLecNt97kVg1sDeKzp/SZb7y1ZvfPOcHoA4rgde8Sn96PhzPkEE6HaLHPM+aK+tsgrzlwbHcBsdMIoR/kqCEiHcV3xKcRzaE37gGarS4qjiTpzmcTCOswA4YFdxffeBUQjiw=";
    public static String OSS_SIGNER_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs//kkj/bZxsnVSlRtDfg+RBIOC/cE2S1Q0XhN2jdD8QmMge46I+sYx0dgCgwiDNjn2yFASWwJyhV1gPbtY8rdNHKzHqQ7KIkh5qEF59mL8EqsG9Cn+ce6y0fB+HPrASTNlkK5ZSsRKo0ZNoI3T/rxJOPFbYHwEnop/skujr3/cqXwCwoUnDD2rlnMP2atS/rqaBB4g3JVKEtQyAfnyBsFTK/xy7zoSBrEIMbmtsQV9GfgYnHo40IHZwaJSHNz6/jUsdolSK5m3Yun03EwUidI8sw8IhqddVLvBcIph1yDWin7bpeqmnYmTBxQZNMGr92D+aNeTrwOqo0ynYzND4J8QIDAQAB";

    public static String generateLicense(OssBssLicense licenseToBeIssued) throws Throwable {
        String result = null;
        if (licenseToBeIssued.type.equals("S")) {
            result = LicenseGeneratorOssWrapper.generateSoftwareLicense(licenseToBeIssued);
        }
        if (licenseToBeIssued.type.equals("H")) {
            result = LicenseGeneratorOssWrapper.generateHardwareLicense(licenseToBeIssued);
        }
        return result;
    }

    private static String generateHardwareLicense(OssBssLicense licenseToBeIssued) {
        Properties p = new Properties();
        p.setProperty("LICENSE_CONTENT_FEATURE", licenseToBeIssued.feature);
        p.setProperty("LICENSE_CONTENT_GUID", licenseToBeIssued.guid);
        String licenseRequest = licenseToBeIssued.incomingLicenseRequest;
        licenseRequest = licenseRequest.replaceAll("\\s", "");
        String hardwareId = LicenseUtils.getMd5Digest(licenseRequest);
        p.setProperty("LICENSE_CONTENT_HARDWARE_ID", hardwareId);
        p.setProperty("LICENSE_CONTENT_COUNT", licenseToBeIssued.count.toString());
        DateFormat df = OssBssLicense.getDateFormat();
        p.setProperty("LICENSE_CONTENT_EXPIRY_DATE", df.format(licenseToBeIssued.expiryDate));
        p.setProperty("LICENSE_CONTENT_DESCRIPTION", licenseToBeIssued.description);
        if (licenseToBeIssued.version != null && licenseToBeIssued.version.length() > 0) {
            p.setProperty("LICENSE_CONTENT_VERSION", licenseToBeIssued.version);
        }
        LicenseGeneratorOssWrapper.fillConfigurationProperties(p);
        LicenseRequest request = new LicenseRequest(CIPHER_PASSWORD, licenseToBeIssued.incomingLicenseRequest);
        LicenseGenerator generator = new LicenseGenerator(request, p, true);
        generator.generate();
        String finalLicense = generator.makeLicenseForOss();
        byte[] encodedSwLic = Base64.encodeBase64(finalLicense.toString().getBytes());
        String encodedStr = new String(encodedSwLic);
        return encodedStr;
    }

    private static String generateSoftwareLicense(OssBssLicense licenseToBeIssued) throws Throwable {
        byte[] pk = OSS_SIGNER_SECRET_KEY.getBytes();
        String feature = licenseToBeIssued.feature;
        Long count = (long)licenseToBeIssued.count;
        Date expiry_date = licenseToBeIssued.expiryDate;
        String description = licenseToBeIssued.description;
        String version = licenseToBeIssued.version;
        String signature = Signer.generateSignature(pk, feature, count, expiry_date);
        StringBuilder finalLicense = new StringBuilder();
        finalLicense.append("feature=");
        finalLicense.append(feature);
        finalLicense.append("\nguid=");
        finalLicense.append(licenseToBeIssued.guid);
        finalLicense.append("\nhardwareId=");
        finalLicense.append("not applicable");
        finalLicense.append("\ncount=");
        finalLicense.append(count);
        finalLicense.append("\nexpiry_date=");
        DateFormat df = OssBssLicense.getDateFormat();
        finalLicense.append(df.format(expiry_date));
        finalLicense.append("\ndescription=");
        finalLicense.append(description);
        if (version != null && version.length() > 0) {
            finalLicense.append("\nversion=");
            finalLicense.append(version);
        }
        finalLicense.append("\nsignature=");
        finalLicense.append(signature);
        byte[] encodedSwLic = Base64.encodeBase64(finalLicense.toString().getBytes());
        String encodedStr = new String(encodedSwLic);
        return encodedStr;
    }

    private static void fillConfigurationProperties(Properties p) {
        p.setProperty("HOLDER", LICENSE_HOLDER);
        p.setProperty("SEC_SUBJECT", "OSS_BSS_LICENSE");
        p.setProperty("SEC_CIPHER", CIPHER_PASSWORD);
        p.setProperty("SEC_KEYSTORE_DIR", SEC_KEYSTORE_DIR);
        p.setProperty("SEC_ALGORITHM", SEC_ALGORITHM);
        p.setProperty("SEC_KEY_LENGTH", SEC_KEY_LENGTH);
        p.setProperty("SEC_KEYSTORE_TYPE", SEC_KEYSTORE_TYPE);
        p.setProperty("SEC_KEYSTORE_ALIAS", SEC_KEYSTORE_ALIAS);
        p.setProperty("SEC_KEYSTORE_PASS", SEC_KEYSTORE_PASS);
        p.setProperty("SEC_KEY_PASS", SEC_KEY_PASS);
        p.setProperty("SEC_KEYSTORE", SEC_KEYSTORE);
        p.setProperty("SEC_PUBLIC_KEYSTORE_ALIAS", SEC_PUBLIC_KEYSTORE_ALIAS);
        p.setProperty("SEC_PUBLIC_KEYSTORE", SEC_PUBLIC_KEYSTORE);
        p.setProperty("SEC_PUBLIC_KEYSTORE_PASS", SEC_PUBLIC_KEYSTORE_PASS);
        p.setProperty(LicenseUtils.PROPERTY_ISSUER, LICENSE_ISSUER);
    }
}

