/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseParam;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.prefs.Preferences;

public class LicenseParamImpl
implements LicenseParam {
    protected String cipherPassword;
    protected String keystoreAlias;
    protected String keyPassword;
    protected String keyStorePassword;
    protected String keyStore;
    protected String subject;
    protected Class clazz;

    public LicenseParamImpl(String cipherPassword, String keystoreAlias, String keyPassword, String keyStorePassword, String keyStore, String subject, Class clazz) {
        this.cipherPassword = cipherPassword;
        this.keystoreAlias = keystoreAlias;
        this.keyPassword = keyPassword;
        this.keyStorePassword = keyStorePassword;
        this.keyStore = keyStore;
        this.subject = subject;
        this.clazz = clazz;
    }

    @Override
    public CipherParam getCipherParam() {
        return new CipherParam(){

            @Override
            public String getKeyPwd() {
                return LicenseParamImpl.this.cipherPassword;
            }
        };
    }

    @Override
    public KeyStoreParam getKeyStoreParam() {
        return new KeyStoreParam(){

            @Override
            public String getAlias() {
                return LicenseParamImpl.this.keystoreAlias;
            }

            @Override
            public String getKeyPwd() {
                return LicenseParamImpl.this.keyPassword;
            }

            @Override
            public String getStorePwd() {
                return LicenseParamImpl.this.keyStorePassword;
            }

            @Override
            public InputStream getStream() throws IOException {
                String resourceName = LicenseParamImpl.this.keyStore;
                InputStream in = this.getClass().getResourceAsStream(resourceName);
                if (in == null) {
                    throw new FileNotFoundException(resourceName);
                }
                return in;
            }
        };
    }

    @Override
    public Preferences getPreferences() {
        return Preferences.userNodeForPackage(this.clazz);
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

