/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license;

import com.veraxsystems.commons.license.LicenseUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.crypto.CipherOutputStream;
import org.apache.commons.codec.binary.Base64;

public final class LicenseRequest {
    private String cipherPass;
    private Properties properties;
    private String encrypted;
    private static final String BASE64_CHARSET = "US-ASCII";

    public LicenseRequest(String cipherPass, Properties properties) {
        this.cipherPass = cipherPass;
        this.properties = properties;
    }

    public LicenseRequest(String cipherPass, String encryptedRequest) {
        this.cipherPass = cipherPass;
        this.encrypted = encryptedRequest;
    }

    public synchronized Properties getProperties() throws IOException, GeneralSecurityException, ClassNotFoundException {
        if (this.properties == null && this.encrypted != null) {
            String plain = new String(this.encrypted);
            if ((plain = LicenseUtils.formatLicenseText(plain, false)).substring(0, "--------------LICENSE REQUEST----------------".length()).equals("--------------LICENSE REQUEST----------------")) {
                plain = plain.substring("--------------LICENSE REQUEST----------------".length());
            }
            if (plain.substring(plain.length() - "----------END OF LICENSE REQUEST-------------".length()).equals("----------END OF LICENSE REQUEST-------------")) {
                plain = plain.substring(0, plain.length() - "----------END OF LICENSE REQUEST-------------".length());
            }
            this.properties = (Properties)this.decrypt(plain);
        }
        return this.properties;
    }

    public synchronized String getEncrypted() throws IOException, GeneralSecurityException {
        if (this.encrypted == null && this.properties != null) {
            this.encrypted = this.encrypt(this.properties);
            String decorated = "--------------LICENSE REQUEST----------------\n";
            decorated = decorated + LicenseUtils.formatLicenseText(this.encrypted, true);
            this.encrypted = decorated = decorated + "----------END OF LICENSE REQUEST-------------";
        }
        return this.encrypted;
    }

    private byte[] serializeObject(Object object) throws IOException {
        byte[] result = null;
        ByteArrayOutputStream dec = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(dec);
        out.writeObject(object);
        out.flush();
        out.close();
        result = dec.toByteArray();
        dec.close();
        return result;
    }

    private Object deserializeObject(byte[] buffer) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(is);
        ois.close();
        return ois.readObject();
    }

    private String encrypt(Object object) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream encryptedStream = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(encryptedStream, LicenseUtils.getCipher(this.cipherPass, 1));
        ((OutputStream)os).write(this.serializeObject(object));
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        byte[] encrypted = Base64.encodeBase64(encryptedStream.toByteArray());
        encryptedStream.close();
        return new String(encrypted, 0, encrypted.length, BASE64_CHARSET);
    }

    private Object decrypt(String request) throws IOException, GeneralSecurityException, ClassNotFoundException {
        Object result = null;
        if (request != null) {
            byte[] encrypted = Base64.decodeBase64(request.getBytes());
            ByteArrayOutputStream decryptedStream = new ByteArrayOutputStream();
            CipherOutputStream os = new CipherOutputStream(decryptedStream, LicenseUtils.getCipher(this.cipherPass, 2));
            ((OutputStream)os).write(encrypted);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            result = this.deserializeObject(decryptedStream.toByteArray());
        }
        return result;
    }
}

