/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license;

import de.schlichtherle.util.ObfuscatedString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class LicenseUtils {
    private static final String EMPTY_MAC = "00:00:00:00:00:00";
    private static Logger logger = Logger.getLogger(LicenseUtils.class);
    private static final int LC_DECORATOR_LINE_LENGTH = 50;
    private static final String BASE64_CHARSET = "US-ASCII";
    public static final String PROPERTY_SEC_CIPHER = new ObfuscatedString(new long[]{20210056200819906L, -2041902727606534429L, -8949468811256247915L}).toString();
    public static final String PROPERTY_SEC_KEYSTORE_ALIAS = new ObfuscatedString(new long[]{-7352070788711171779L, -7696351394535159995L, 4298202160923247154L, -4140440755196448109L}).toString();
    public static final String PROPERTY_SEC_KEY_PASS = new ObfuscatedString(new long[]{7350722897012520034L, -143469910447181772L, -6990727595594673589L}).toString();
    public static final String PROPERTY_SEC_KEYSTORE_PASS = new ObfuscatedString(new long[]{-8241974646305711603L, 6919093780159790946L, 7003553602545688809L, -1406121091949501837L}).toString();
    public static final String PROPERTY_SEC_KEYSTORE = new ObfuscatedString(new long[]{-3447234856199139576L, -7027029088448007316L, 1874670438305194607L}).toString();
    public static final String PROPERTY_SEC_SUBJECT = new ObfuscatedString(new long[]{-3095855192476241871L, 1648424025492879968L, 7166782300088740004L}).toString();
    public static final String PROPERTY_SEC_HARDWARE_ADDRESSES = new ObfuscatedString(new long[]{6820891342078844415L, -130940643049038026L, 59215630546380366L, 4867833851978248397L}).toString();
    public static final String PROPERTY_SEC_PUBLIC_KEYSTORE_ALIAS = new ObfuscatedString(new long[]{-49542297057368415L, -2747793256252755600L, 2657868212658468764L, -7140486337596219623L, 8550385236092954313L}).toString();
    public static final String PROPERTY_SEC_PUBLIC_KEYSTORE_PASS = new ObfuscatedString(new long[]{6223140994502271711L, 1626167369662478444L, -8296677952361775972L, -4020733214393191572L}).toString();
    public static final String PROPERTY_SEC_PUBLIC_KEYSTORE = new ObfuscatedString(new long[]{1705811744010337063L, -1095659745118649395L, -7967351017679137388L, 6888723081065437302L}).toString();
    public static final String PROPERTY_SEC_ALGORITHM = new ObfuscatedString(new long[]{-1014644606769539303L, 1651520864257056614L, -453781586450942920L}).toString();
    public static final String PROPERTY_SEC_KEY_LENGTH = new ObfuscatedString(new long[]{3285442881103773074L, -4828533009690233130L, -4618204810016832256L}).toString();
    public static final String PROPERTY_SEC_KEYSTORE_TYPE = new ObfuscatedString(new long[]{-4988295077215016987L, 1682373201655449078L, -8621584800698219510L, 4208938906533921372L}).toString();
    public static final String PROPERTY_SEC_KEYSTORE_DIR = new ObfuscatedString(new long[]{1360926752721944211L, -984032413469160554L, 3679132798961507290L}).toString();
    public static final String PROPERTY_SEC_ISSUER_CN = new ObfuscatedString(new long[]{2584204402941910890L, 4223419006049199017L, 8986508783861903489L}).toString();
    public static final String PROPERTY_SEC_ISSUER_OU = new ObfuscatedString(new long[]{1139145883399273967L, -7606877266487507835L, -1489150559364032371L}).toString();
    public static final String PROPERTY_SEC_ISSUER_O = new ObfuscatedString(new long[]{2856135455062437375L, -3057303813933847243L, -2310185758262853685L}).toString();
    public static final String PROPERTY_SEC_ISSUER_L = new ObfuscatedString(new long[]{994371334570818119L, 3247242539976620542L, 8624041178798889587L}).toString();
    public static final String PROPERTY_SEC_ISSUER_ST = new ObfuscatedString(new long[]{9035539279112476881L, 6338100809203778956L, 3441051507715555963L}).toString();
    public static final String PROPERTY_SEC_ISSUER_C = new ObfuscatedString(new long[]{3915398846575259639L, -961241033795241332L, 6632577770587042169L}).toString();
    public static final String PROPERTY_SEC_SUBJECT_CN = new ObfuscatedString(new long[]{-3035153130771321879L, -1028475840728995672L, 248035838527458535L}).toString();
    public static final String PROPERTY_SEC_SUBJECT_OU = new ObfuscatedString(new long[]{-2793280762559792446L, -730236234322061593L, 2746546464901749214L}).toString();
    public static final String PROPERTY_SEC_SUBJECT_O = new ObfuscatedString(new long[]{2474436082066062419L, 3215956805705914116L, 22985923298733190L}).toString();
    public static final String PROPERTY_SEC_SUBJECT_L = new ObfuscatedString(new long[]{7467972230690985937L, 438115878507031998L, -6755745700951692697L}).toString();
    public static final String PROPERTY_SEC_SUBJECT_ST = new ObfuscatedString(new long[]{6124824804300915070L, 6767876589156337758L, 8195444599142501555L}).toString();
    public static final String PROPERTY_SEC_SUBJECT_C = new ObfuscatedString(new long[]{911705744266848360L, -6898636085188247802L, 4792584054520253954L}).toString();
    public static final String PROPERTY_SEC_TRIAL_KEYSTORE_ALIAS = new ObfuscatedString(new long[]{-6802639276822613189L, -8556485508089024049L, 62296858404468571L, 4935209877048387544L}).toString();
    public static final String PROPERTY_SEC_TRIAL_KEYSTORE_PASS = new ObfuscatedString(new long[]{6607129230569134492L, -2521329815153755825L, -8643654896719218565L, 4712647260213672576L}).toString();
    public static final String PROPERTY_SEC_TRIAL_KEY_PASS = new ObfuscatedString(new long[]{7926265068421049311L, -4480874350897407559L, 4595240368015331548L, 92409402853184807L}).toString();
    public static final String PROPERTY_SEC_TRIAL_KEYSTORE = new ObfuscatedString(new long[]{-5497593047676615295L, -4063211567348026503L, -3178788005827919684L, 2634383647133921706L}).toString();
    public static final String PROPERTY_SEC_TRIAL_ISSUER_CN = new ObfuscatedString(new long[]{-7750387136123166443L, -2792130113528221146L, 4645972925358486358L, 2261049547098349571L}).toString();
    public static final String PROPERTY_SEC_TRIAL_ISSUER_OU = new ObfuscatedString(new long[]{3263411284447391663L, 7653715439704800816L, -7355247477452005376L, -1803716931857671570L}).toString();
    public static final String PROPERTY_SEC_TRIAL_ISSUER_O = new ObfuscatedString(new long[]{8227729253723135293L, -5792035254920277281L, -4046248957531346108L, -6575225492230488009L}).toString();
    public static final String PROPERTY_SEC_TRIAL_ISSUER_L = new ObfuscatedString(new long[]{-8646252071363909645L, -8773840244526935194L, 1903354954889300013L, -5075609995830181253L}).toString();
    public static final String PROPERTY_SEC_TRIAL_ISSUER_ST = new ObfuscatedString(new long[]{847801777982919137L, 3614017170988833818L, -4692718875640157254L, 6224129150405589232L}).toString();
    public static final String PROPERTY_SEC_TRIAL_ISSUER_C = new ObfuscatedString(new long[]{3537627301504616168L, 8229036612054725248L, 5587627430064586505L, 9045339764631940053L}).toString();
    public static final String PROPERTY_SEC_TRIAL_SUBJECT_CN = new ObfuscatedString(new long[]{516682140009744123L, 7293863273443625941L, 2285402363178336575L, -2501173089866554128L}).toString();
    public static final String PROPERTY_SEC_TRIAL_SUBJECT_OU = new ObfuscatedString(new long[]{2253698965467210714L, -7082768093817593410L, -8760635126705406406L, -1367555696368007573L}).toString();
    public static final String PROPERTY_SEC_TRIAL_SUBJECT_O = new ObfuscatedString(new long[]{6835035567061732091L, 8516510318468238507L, 4041447617583899768L, 2812735561354531650L}).toString();
    public static final String PROPERTY_SEC_TRIAL_SUBJECT_L = new ObfuscatedString(new long[]{-384262572960515589L, 1619082888847691236L, 983536901300098044L, 5877425108937927852L}).toString();
    public static final String PROPERTY_SEC_TRIAL_SUBJECT_ST = new ObfuscatedString(new long[]{7777823406951945583L, 3397485874886899161L, 5852758769490498027L, -3362961326376373304L}).toString();
    public static final String PROPERTY_SEC_TRIAL_SUBJECT_C = new ObfuscatedString(new long[]{-6193672131697320949L, 5205715475223332833L, 386383692328255141L, -7707529617626820784L}).toString();
    public static final String X500_CN = new ObfuscatedString(new long[]{5144013141077247021L, 9219468104322972172L}).toString();
    public static final String X500_OU = new ObfuscatedString(new long[]{2330681539029244102L, 8235878241863583244L}).toString();
    public static final String X500_O = new ObfuscatedString(new long[]{-2178545174131146904L, 2843246685267794264L}).toString();
    public static final String X500_L = new ObfuscatedString(new long[]{5557966309347001899L, -5536135133096445337L}).toString();
    public static final String X500_ST = new ObfuscatedString(new long[]{-4542022615374837922L, 6964065939784815214L}).toString();
    public static final String X500_C = new ObfuscatedString(new long[]{2455720346748024666L, -5868965992024366003L}).toString();
    public static final String PROPERTY_HOLDER = new ObfuscatedString(new long[]{-6282555989164296760L, 3862984502081518241L}).toString();
    public static final String PROPERTY_ISSUER = new ObfuscatedString(new long[]{5113361119467304873L, 5170065640792487658L}).toString();
    public static final String EQUAL = new ObfuscatedString(new long[]{8922214285176968616L, 1400662584429422039L}).toString();
    public static final String TRIAL_LICENSE = new ObfuscatedString(new long[]{-5820793799772108449L, 2914552038873339380L, -3567360396437420705L}).toString();
    public static final String COMMERCIAL_LICENSE = new ObfuscatedString(new long[]{8463533609000917714L, 4211805503662167921L, -1544825462923551895L, -3954331685818236484L}).toString();
    public static final String TRIAL_DAYS = new ObfuscatedString(new long[]{-6048653314450071421L, 4196089012378512628L, -1275067836548950432L}).toString();
    public static final String TRIAL_INSTALLED = new ObfuscatedString(new long[]{-5340461631404196335L, 6118321072810426611L, 3076639483469055235L}).toString();
    public static final String TRIAL_HOLDER = new ObfuscatedString(new long[]{8368653352831445368L, 3739765611742445754L, -6490686145525608435L, 93017363941634849L, -6229231474545301008L}).toString();
    public static final String TRIAL_ISSUER = new ObfuscatedString(new long[]{-8402479059483323379L, -4869454053907217699L, -8317208889026803528L, -4205204578496506594L}).toString();
    public static final String EX_GENERATING = new ObfuscatedString(new long[]{-5558890346213565604L, -1447479259005617313L, 2713820133190569911L, 8868127292901414235L, -2721536018632882126L, 4296472269845577813L}).toString();
    public static final String EX_HDWADDR_INVALID = new ObfuscatedString(new long[]{6455333154905839005L, 1069491007902054844L, 7156691074088735305L, 3725584250104263263L}).toString();
    public static final String EX_LICENSE_INVALID = new ObfuscatedString(new long[]{-3033105075127182893L, -4205774470144599416L, -5409463035526605124L}).toString();
    public static final String EX_INSTALL_FAILED = new ObfuscatedString(new long[]{-5454386703428616388L, -4885334347846721809L, -769526159533432713L, -8990055270541966245L, -5110034272604737031L}).toString();
    private static final String CIPHER_PASS = "l4m3r1k42008tr1p";
    private static final String SIGNED_FILE_WITH_X500PRINCIPAL = "/sfp";
    private static final String PBE_WITH_MD5_AND_DES = new ObfuscatedString(new long[]{2860604316472308139L, 5030391952891038168L, -6110818099732428353L}).toString();
    private static final String GENERATED_SIGNATURE_ALGORITHM = "SHA1WithRSAEncryption";

    public static final Cipher getCipher(String pass, int mode) throws GeneralSecurityException {
        Cipher result = null;
        PBEKeySpec keySpec = new PBEKeySpec(pass.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PBE_WITH_MD5_AND_DES);
        SecretKey key = keyFac.generateSecret(keySpec);
        result = Cipher.getInstance(PBE_WITH_MD5_AND_DES);
        PBEParameterSpec algoParamSpec = new PBEParameterSpec(new byte[]{-50, -5, -34, -84, 5, 2, 25, 113}, 2005);
        result.init(mode, (Key)key, algoParamSpec);
        return result;
    }

    private static final Certificate generateCertificate(KeyPair keyPair, X500Principal subject, X500Principal issuer, Date notBefore, Date notAfter) throws GeneralSecurityException {
        Security.addProvider(new BouncyCastleProvider());
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(Math.abs(new SecureRandom().nextInt())));
        certGen.setIssuerDN(issuer);
        certGen.setNotBefore(notBefore);
        certGen.setNotAfter(notAfter);
        certGen.setSubjectDN(subject);
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm(GENERATED_SIGNATURE_ALGORITHM);
        X509Certificate cert = certGen.generate(keyPair.getPrivate());
        cert.checkValidity(new Date());
        cert.verify(keyPair.getPublic());
        return cert;
    }

    public static final KeyStore createSecretKeystore(String alias, String password, X500Principal subject, X500Principal issuer, Date notBefore, Date notAfter, String algorithm, int keyLength, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        SecureRandom random = new SecureRandom();
        keyGen.initialize(keyLength, random);
        KeyPair keyPair = keyGen.genKeyPair();
        Certificate cert = LicenseUtils.generateCertificate(keyPair, subject, issuer, notBefore, notAfter);
        Certificate[] certificate = new Certificate[]{cert};
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setKeyEntry(alias, keyPair.getPrivate(), password.toCharArray(), certificate);
        return keyStore;
    }

    public static final KeyStore exportPublicKeystore(KeyStore secretKeyStore, String secretAlias, String certificateAlias, String keyStoreType) throws GeneralSecurityException, IOException {
        Certificate certificate = secretKeyStore.getCertificate(secretAlias);
        KeyStore result = KeyStore.getInstance(keyStoreType);
        result.load(null, null);
        result.setCertificateEntry(certificateAlias, certificate);
        return result;
    }

    private static final X500Principal getX500Principal() throws GeneralSecurityException, IOException, ClassNotFoundException {
        X500Principal result = null;
        InputStream is = LicenseUtils.class.getResourceAsStream(SIGNED_FILE_WITH_X500PRINCIPAL);
        CipherInputStream cis = new CipherInputStream(is, LicenseUtils.getCipher(CIPHER_PASS, 2));
        ObjectInputStream ois = new ObjectInputStream(cis);
        result = (X500Principal)ois.readObject();
        ois.close();
        return result;
    }

    private static final void storeX500Principal(X500Principal principal, File file) throws IOException, GeneralSecurityException {
        FileOutputStream fos = new FileOutputStream(file);
        CipherOutputStream os = new CipherOutputStream(fos, LicenseUtils.getCipher(CIPHER_PASS, 2));
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(principal);
        out.flush();
        out.close();
        ((OutputStream)os).close();
        fos.close();
    }

    private static final File getFile(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        return f;
    }

    private static final URL detectSourceLocation() {
        Class<LicenseUtils> cls = LicenseUtils.class;
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        URL loc = cSource.getLocation();
        return loc;
    }

    private static final void verifyCert(X509Certificate cert) throws GeneralSecurityException, IOException, ClassNotFoundException {
        cert.checkValidity();
        if (!cert.getSubjectX500Principal().getEncoded().equals(LicenseUtils.getX500Principal())) {
            throw new CertificateException("Wrong public key!");
        }
    }

    public static final String verifySource() throws SecurityException {
        StringBuffer result = new StringBuffer();
        try {
            File file = LicenseUtils.getFile(LicenseUtils.detectSourceLocation());
            FileInputStream fileIs = new FileInputStream(file);
            boolean verify = true;
            JarInputStream jarIs = new JarInputStream((InputStream)fileIs, verify);
            JarEntry entry = null;
            JarEntry Entry2 = null;
            while ((entry = jarIs.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                Entry2 = entry;
            }
            Certificate[] certs = Entry2.getCertificates();
            if (certs == null) {
                throw new SecurityException("The jar is not signed");
            }
            for (int i = 0; i < Array.getLength(certs); ++i) {
                LicenseUtils.verifyCert((X509Certificate)certs[i]);
            }
        }
        catch (Throwable t) {
            throw new SecurityException(t);
        }
        return result.toString();
    }

    public static final String formatLicenseText(String licenseText, boolean wrap) {
        String result = null;
        if (wrap) {
            StringBuffer sb = new StringBuffer();
            int rows = licenseText.length() / 50 + (licenseText.length() % 50 == 0 ? 0 : 1);
            for (int i = 0; i < rows; ++i) {
                int index = i * 50;
                if (index + 50 > licenseText.length()) {
                    sb.append(licenseText.substring(index)).append("\n");
                    continue;
                }
                sb.append(licenseText.substring(index, index + 50)).append("\n");
            }
            result = sb.toString();
        } else {
            result = licenseText.replaceAll("\n", "");
        }
        return result.toString();
    }

    public static String getHardwareSignature() throws SocketException {
        String result = EMPTY_MAC;
        ArrayList<NetworkInterface> filteredInterfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface networkInterface : Collections.list(nets)) {
            if (networkInterface == null || networkInterface.getHardwareAddress() == null || networkInterface.getHardwareAddress().length <= 0 || networkInterface.isLoopback() || networkInterface.isVirtual() || networkInterface.isPointToPoint()) continue;
            filteredInterfaces.add(networkInterface);
        }
        Collections.sort(filteredInterfaces, new Comparator<NetworkInterface>(){

            @Override
            public int compare(NetworkInterface iface1, NetworkInterface iface2) {
                return iface1.getName().compareTo(iface2.getName());
            }
        });
        int curNum = Integer.MAX_VALUE;
        NetworkInterface bestMatch = null;
        for (NetworkInterface networkInterface : filteredInterfaces) {
            String number;
            if (!networkInterface.getName().startsWith("eth") || !(number = networkInterface.getName().substring(3)).matches("-?\\d+(\\.\\d+)?")) continue;
            try {
                int num = Integer.parseInt(number);
                if (num >= curNum) continue;
                curNum = num;
                bestMatch = networkInterface;
            }
            catch (NumberFormatException e) {
                logger.warn("Error parsing NetworkInterface's name", e);
            }
        }
        if (bestMatch == null && filteredInterfaces.size() > 0) {
            bestMatch = (NetworkInterface)filteredInterfaces.get(0);
        }
        if (bestMatch != null) {
            result = Arrays.toString(bestMatch.getHardwareAddress());
        }
        logger.info("Picked MAC address : " + result);
        return result;
    }

    @Deprecated
    public static String getHardwareAddresses() throws SocketException {
        StringBuffer result = new StringBuffer("");
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface netint : Collections.list(nets)) {
            if (netint.getHardwareAddress() == null) continue;
            result = result.append(Arrays.toString(netint.getHardwareAddress()));
        }
        return result.toString();
    }

    public static String storeAsBase64(byte[] content) {
        String result = null;
        try {
            byte[] encoded = Base64.encodeBase64(content);
            result = new String(encoded, 0, encoded.length, BASE64_CHARSET);
        }
        catch (Throwable t) {
            System.err.println("Problem with creating content as Base64");
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public static String getMd5Digest(String pInput) {
        try {
            MessageDigest lDigest = MessageDigest.getInstance("MD5");
            lDigest.update(pInput.getBytes());
            BigInteger lHashInt = new BigInteger(1, lDigest.digest());
            return String.format("%1$032X", lHashInt);
        }
        catch (NoSuchAlgorithmException lException) {
            throw new RuntimeException(lException);
        }
    }
}

