/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license;

import com.veraxsystems.commons.license.LicenseParamImpl;
import com.veraxsystems.commons.license.LicenseUtils;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.ftp.LicenseParam;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;

public abstract class TrialLicenseParamImpl
extends LicenseParamImpl
implements LicenseParam {
    private int trialDays;
    private String trialKeystoreAlias;
    private String trialKeyPassword;
    private String trialKeyStorePassword;
    private String trialKeyStore;

    public TrialLicenseParamImpl(String cipher, String keystoreAlias, String keyPassword, String keyStorePassword, String keyStore, String subject, Class clazz) {
        super(cipher, keystoreAlias, keyPassword, keyStorePassword, keyStore, subject, clazz);
    }

    public void setTrialParams(int trialDays, String trialKeystoreAlias, String trialKeyPassword, String trialKeyStorePassword, String trialKeyStore) {
        this.trialDays = trialDays;
        this.trialKeystoreAlias = trialKeystoreAlias;
        this.trialKeyPassword = trialKeyPassword;
        this.trialKeyStorePassword = trialKeyStorePassword;
        this.trialKeyStore = trialKeyStore;
    }

    @Override
    public LicenseContent createFTPLicenseContent() {
        LicenseContent result = new LicenseContent();
        try {
            X500Principal holder = new X500Principal(LicenseUtils.TRIAL_HOLDER);
            result.setHolder(holder);
            X500Principal issuer = new X500Principal(LicenseUtils.TRIAL_ISSUER);
            result.setIssuer(issuer);
            result.setConsumerAmount(1);
            result.setConsumerType("User");
            result.setIssued(new Date());
            result.setInfo(LicenseUtils.TRIAL_LICENSE);
            Properties properties = new Properties();
            properties.setProperty(LicenseUtils.TRIAL_DAYS, Integer.valueOf(this.trialDays).toString());
            result.setExtra(properties);
        }
        catch (Throwable t) {
            throw new SecurityException(LicenseUtils.EX_GENERATING);
        }
        return result;
    }

    @Override
    public void ftpGranted(LicenseContent arg0) {
    }

    @Override
    public int getFTPDays() {
        return this.trialDays;
    }

    public void setFTPDays(int trialDays) {
        this.trialDays = trialDays;
    }

    @Override
    public KeyStoreParam getFTPKeyStoreParam() {
        return new KeyStoreParam(){

            @Override
            public String getAlias() {
                return TrialLicenseParamImpl.this.trialKeystoreAlias;
            }

            @Override
            public String getKeyPwd() {
                return TrialLicenseParamImpl.this.trialKeyPassword;
            }

            @Override
            public String getStorePwd() {
                return TrialLicenseParamImpl.this.trialKeyStorePassword;
            }

            @Override
            public InputStream getStream() throws IOException {
                String resourceName = TrialLicenseParamImpl.this.trialKeyStore;
                InputStream in = this.getClass().getResourceAsStream(resourceName);
                if (in == null) {
                    throw new FileNotFoundException(resourceName);
                }
                return in;
            }
        };
    }

    @Override
    public abstract boolean isFTPEligible();

    @Override
    public abstract void removeFTPEligibility();
}

