/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.license.gui;

import com.veraxsystems.commons.license.LicenseGeneratorOssWrapper;
import com.veraxsystems.commons.license.gui.ComboboxToolTipRenderer;
import com.veraxsystems.commons.updater.utils.OssBssLicense;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.UUID;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.DateFormatter;
import javax.swing.text.MaskFormatter;
import org.apache.log4j.Logger;

public class LicenseCreator
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String GUI_TITLE = "OSS/BSS License Generator";
    private static final boolean DEFAULT_SOFTWARE_LICENSE = true;
    private static final String HARDWARE_SUFFIX = "hw";
    private static final String SOFTWARE_SUFFIX = "sw";
    private static Logger logger = Logger.getLogger(LicenseCreator.class);
    private static final int VSIZE = 535;
    private static final int HSIZE = 625;
    private OssBssLicense lastLicense;
    JLabel lLicenseType = new JLabel("License type");
    JLabel lFeature = new JLabel("Feature");
    JLabel lCount = new JLabel("Count");
    JLabel lDescription = new JLabel("Description");
    JLabel lExpiryDate = new JLabel("Expiry Date (yyyy-MM-dd)");
    JLabel lLicenseGUID = new JLabel("License GUID");
    JLabel lVersion = new JLabel("Version");
    JLabel lLicenseRequest = new JLabel("License Request");
    JLabel lGeneratedLicense = new JLabel("Generated License");
    JRadioButton rbSoftwareLicense = new JRadioButton("Software License");
    JRadioButton rbHardwareLicense = new JRadioButton("Hardware License");
    JComboBox tFeature = new JComboBox();
    NumberFormat nf = NumberFormat.getInstance();
    JFormattedTextField tCount;
    DateFormatter dft;
    JFormattedTextField tExpiryDate;
    JTextField tDescription;
    JTextField tLicenseGUID;
    JComboBox tVersion;
    JTextField tChecker;
    JButton bCheck;
    JTextArea tLicenseRequest;
    JTextArea tGeneratedLicense;
    JButton bCopy;
    JButton bSave;
    JButton bReset;
    private String lastRequest;
    ActionListener rbActionListener;
    Toolkit toolkit;

    public LicenseCreator() {
        this.nf.setGroupingUsed(false);
        this.tCount = new JFormattedTextField(this.nf);
        this.dft = new DateFormatter(new SimpleDateFormat("yyyy-MM-dd"));
        this.tExpiryDate = new JFormattedTextField(this.dft);
        this.tDescription = new JTextField();
        this.tLicenseGUID = new JTextField();
        this.tVersion = new JComboBox();
        this.tChecker = new JTextField();
        this.bCheck = new JButton();
        this.tLicenseRequest = new JTextArea();
        this.tGeneratedLicense = new JTextArea();
        this.bCopy = new JButton("Copy to clipboard");
        this.bSave = new JButton("Save to file");
        this.bReset = new JButton("Reset form");
        this.lastRequest = null;
        this.rbActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseCreator.this.changeLicenseType();
            }
        };
        this.toolkit = this.getToolkit();
        this.setSize(625, 535);
        this.setTitle("OSS/BSS License Generator " + this.getVersion());
        this.setDefaultCloseOperation(3);
        Dimension size = this.toolkit.getScreenSize();
        this.setLocation(size.width / 2 - this.getWidth() / 2, size.height / 2 - this.getHeight() / 2);
        JPanel panel = new JPanel();
        panel.setLayout(null);
        this.getContentPane().add(panel);
        int yPos = 5;
        this.lLicenseType.setBounds(5, yPos, 300, 20);
        this.lFeature.setBounds(5, yPos += 25, 300, 20);
        this.lCount.setBounds(5, yPos += 25, 300, 20);
        this.lExpiryDate.setBounds(5, yPos += 25, 300, 20);
        this.lDescription.setBounds(5, yPos += 25, 300, 20);
        this.lVersion.setBounds(5, yPos += 25, 300, 20);
        this.lLicenseGUID.setBounds(5, yPos += 50, 300, 20);
        this.lLicenseRequest.setBounds(5, yPos += 25, 300, 20);
        this.bReset.setBounds(5, yPos += 25, 150, 20);
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LicenseCreator.this.resetForm();
            }
        });
        yPos += 25;
        panel.add(this.lLicenseType);
        panel.add(this.lFeature);
        panel.add(this.lCount);
        panel.add(this.lExpiryDate);
        panel.add(this.lDescription);
        panel.add(this.lVersion);
        panel.add(this.lLicenseGUID);
        panel.add(this.lLicenseRequest);
        panel.add(this.bReset);
        yPos = 5;
        this.rbSoftwareLicense.setBounds(205, yPos, 150, 20);
        this.rbSoftwareLicense.addActionListener(this.rbActionListener);
        this.rbHardwareLicense.setBounds(355, yPos, 200, 20);
        yPos += 25;
        this.rbHardwareLicense.addActionListener(this.rbActionListener);
        this.rbHardwareLicense.setSelected(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbHardwareLicense);
        group.add(this.rbSoftwareLicense);
        this.rbSoftwareLicense.setSelected(true);
        this.tFeature.setBounds(205, yPos, 400, 20);
        this.tCount.setBounds(205, yPos += 25, 400, 20);
        this.tExpiryDate.setBounds(205, yPos += 25, 400, 20);
        this.tDescription.setBounds(205, yPos += 25, 400, 20);
        this.tVersion.setBounds(205, yPos += 25, 400, 20);
        this.tVersion.setEditable(true);
        this.populateVersionCB();
        this.tChecker.setBounds(205, yPos += 25, 250, 20);
        this.bCheck.setBounds(460, yPos, 145, 20);
        this.tLicenseGUID.setBounds(205, yPos += 25, 400, 20);
        this.tLicenseRequest.setBounds(205, yPos += 25, 400, 200);
        this.tLicenseRequest.setLineWrap(true);
        this.changeLicenseType();
        yPos += 205;
        panel.add(this.rbSoftwareLicense);
        panel.add(this.rbHardwareLicense);
        panel.add(this.tFeature);
        panel.add(this.tCount);
        panel.add(this.tExpiryDate);
        panel.add(this.tDescription);
        panel.add(this.tVersion);
        panel.add(this.tChecker);
        panel.add(this.bCheck);
        panel.add(this.tLicenseGUID);
        panel.add(this.tLicenseRequest);
        this.tFeature.setEditable(true);
        this.tFeature.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LicenseCreator.this.tDescription.setText(e.getItem().toString());
            }
        });
        this.tFeature.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LicenseCreator.this.tDescription.setText(LicenseCreator.this.tFeature.getEditor().getItem().toString());
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.lGeneratedLicense.setBounds(615, 5, 300, 20);
        this.lGeneratedLicense.setForeground(Color.RED);
        this.tGeneratedLicense.setBounds(615, 30, 300, yPos + 25);
        this.tGeneratedLicense.setLineWrap(true);
        this.tLicenseGUID.setEditable(false);
        yPos = 30 + yPos + 25 + 5;
        this.bCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = LicenseCreator.this.tGeneratedLicense.getText();
                StringSelection data = new StringSelection(selection);
                Clipboard clipboard = LicenseCreator.this.toolkit.getSystemClipboard();
                clipboard.setContents(data, data);
            }
        });
        this.bCopy.setBounds(615, yPos, 150, 20);
        this.bCopy.setVisible(false);
        this.bSave.setBounds(765, yPos, 150, 20);
        this.bSave.setVisible(false);
        this.bSave.addActionListener(new SaveL());
        this.bCheck.setText("Verify regex");
        this.bCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseCreator.this.verifyRegex();
            }
        });
        panel.add(this.tGeneratedLicense);
        panel.add(this.lGeneratedLicense);
        panel.add(this.bCopy);
        panel.add(this.bSave);
        JButton bGenerate = new JButton("Generate");
        bGenerate.setBounds(5, yPos -= 60, 600, 80);
        bGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LicenseCreator.this.generateLicense();
            }
        });
        panel.add(bGenerate);
        this.setup();
    }

    public synchronized String getVersion() {
        Package aPackage;
        String version = null;
        try {
            Properties p = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/verax/commons-license/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        if (version == null && (aPackage = this.getClass().getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            version = "";
        }
        return version;
    }

    private void populateVersionCB() {
        this.tVersion.addItem("\\d+\\.\\d+\\.\\d+");
        this.tVersion.addItem("1\\.2\\.\\d+");
        this.tVersion.addItem("1\\.((3\\.(([6-9]\\d*)|([1-9]\\d+)))|(4\\.\\d+)|(5\\.[0-4]))");
        ComboboxToolTipRenderer renderer = new ComboboxToolTipRenderer();
        this.tVersion.setRenderer(renderer);
        ArrayList<String> tooltips = new ArrayList<String>();
        tooltips.add("X.X.X");
        tooltips.add("1.2.X");
        tooltips.add("1.3.6-1.5.4");
        renderer.setTooltips(tooltips);
    }

    private void verifyRegex() {
        String pattern = this.tVersion.getSelectedItem().toString();
        String test = this.tChecker.getText();
        if (pattern == null || pattern.length() == 0) {
            JOptionPane.showMessageDialog(this, "No pattern provided", "Error", 0);
        } else if (test == null || test.length() == 0) {
            JOptionPane.showMessageDialog(this, "No test expression provided", "Error", 0);
        } else {
            boolean result = test.matches(pattern);
            String message = "";
            message = result ? "Test expression matches regex" : "Test expression does not match regex";
            JOptionPane.showMessageDialog(this, message, "Regex verified", 1);
        }
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    private void changeLicenseType() {
        this.tLicenseRequest.setEnabled(this.rbHardwareLicense.isSelected());
        this.tLicenseRequest.setEditable(this.rbHardwareLicense.isSelected());
        if (this.tLicenseRequest.isEnabled()) {
            this.tLicenseRequest.setBorder(new LineBorder(Color.black));
            this.tLicenseRequest.setBackground(Color.white);
            this.tLicenseRequest.setVisible(true);
            this.lLicenseRequest.setForeground(Color.black);
        } else {
            this.tLicenseRequest.setVisible(false);
        }
    }

    private void setup() {
        try {
            String[] items;
            Properties props = new Properties();
            URL url = ClassLoader.getSystemResource("generator.properties");
            props.load(url.openStream());
            String licenses = props.getProperty("supported.licenses");
            for (String item : items = licenses.split(";")) {
                this.tFeature.addItem(item);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        this.tCount.setText("500");
        Calendar calendar = Calendar.getInstance();
        String date = calendar.get(1) + "-12-31";
        this.tExpiryDate.setText(date);
        this.tLicenseGUID.setText("click \"Generate\" for new GUID");
        this.tLicenseRequest.setText("--------------LICENSE REQUEST----------------\nN4vSG4B7fO80LTX01AYhD+RigKT4JvDKvbAXQqh5z0UkdAey/w\nX1EZ3G4hnCo6fuN8uC+eg7M3G+YKFUtHDvGaYjykBXdTKlmcvX\nzfsGOkifgxhQo/O+nS3LKT1YfjuYbD1NezIGJXC3uZIke8tx5q\npm8+dAbDBLvka0xMGr4P1lB8/XT+bBMDvX59IGi4NHdYdO6ayU\n3tsPkx347Gf2cPjlaQML4MNIjVP1hR7slZFST1CrsnTpuQqwfg\nzB1hTIyKpxnEedUkskze6ivUn15iR+Fa8I2Kaov1J/eqBbKcnN\nLd6Nn5sS6J6i/t4Kkc7t1Mj3KkOQ9s4=\n----------END OF LICENSE REQUEST-------------\n");
    }

    private void generateLicense() {
        OssBssLicense lic = new OssBssLicense();
        lic.feature = this.tFeature.getSelectedItem().toString();
        lic.description = this.tDescription.getText();
        lic.count = Long.parseLong(this.tCount.getText());
        lic.guid = UUID.randomUUID().toString();
        this.tLicenseGUID.setText(lic.guid);
        lic.version = this.tVersion.getSelectedItem().toString();
        DateFormat df = OssBssLicense.getDateFormat();
        try {
            lic.expiryDate = df.parse(this.tExpiryDate.getText());
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        lic.type = this.rbHardwareLicense.isSelected() ? "H" : "S";
        lic.incomingLicenseRequest = this.tLicenseRequest.getText();
        this.lastLicense = lic;
        try {
            this.lastRequest = this.tLicenseRequest.getText();
            String newLicense = LicenseGeneratorOssWrapper.generateLicense(lic);
            JOptionPane.showMessageDialog(this, "License generated", "Done", 1);
            this.tGeneratedLicense.setText(newLicense);
            this.tGeneratedLicense.setBorder(new LineBorder(Color.black));
            this.tGeneratedLicense.setBackground(Color.white);
            this.tGeneratedLicense.setForeground(Color.black);
            this.tGeneratedLicense.setEditable(false);
            this.tGeneratedLicense.setEnabled(true);
            this.tGeneratedLicense.setVisible(true);
            this.setSize(925, 535);
            this.bCopy.setVisible(true);
            this.bSave.setVisible(true);
            this.rbSoftwareLicense.setEnabled(false);
            this.rbHardwareLicense.setEnabled(false);
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Ooops", 0);
            e.printStackTrace();
        }
    }

    private void resetForm() {
        this.tLicenseRequest.setText(this.lastRequest);
        this.tLicenseRequest.setEditable(false);
        this.lLicenseRequest.setText("License Request");
        this.lLicenseRequest.setForeground(Color.black);
        this.rbSoftwareLicense.setEnabled(true);
        this.rbHardwareLicense.setEnabled(true);
        this.bCopy.setVisible(false);
        this.bSave.setVisible(false);
        this.setSize(615, 535);
        this.tGeneratedLicense.setVisible(false);
        this.changeLicenseType();
    }

    public static void main(String[] args) {
        LicenseCreator lc = new LicenseCreator();
        lc.setVisible(true);
    }

    private class SaveL
    implements ActionListener {
        private SaveL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int rVal;
            JFileChooser c = new JFileChooser();
            if (LicenseCreator.this.lastLicense != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(((LicenseCreator)LicenseCreator.this).lastLicense.feature);
                sb.append("-");
                sb.append(((LicenseCreator)LicenseCreator.this).lastLicense.count);
                sb.append("-");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                sb.append(formatter.format((Object)((LicenseCreator)LicenseCreator.this).lastLicense.expiryDate));
                sb.append("-");
                if (((LicenseCreator)LicenseCreator.this).lastLicense.type == "H") {
                    sb.append(LicenseCreator.HARDWARE_SUFFIX);
                } else {
                    sb.append(LicenseCreator.SOFTWARE_SUFFIX);
                }
                sb.append(".lic");
                File f = new File(sb.toString());
                c.setSelectedFile(f);
            }
            if ((rVal = c.showSaveDialog(LicenseCreator.this)) == 0) {
                FileOutputStream outFile = null;
                try {
                    outFile = new FileOutputStream(c.getSelectedFile());
                    outFile.write(LicenseCreator.this.tGeneratedLicense.getText().getBytes());
                    JOptionPane.showMessageDialog(LicenseCreator.this, "File Saved", "OK", 1);
                }
                catch (FileNotFoundException e1) {
                    JOptionPane.showMessageDialog(LicenseCreator.this, e1.getMessage(), "Ooops", 0);
                    e1.printStackTrace();
                }
                catch (IOException e2) {
                    JOptionPane.showMessageDialog(LicenseCreator.this, e2.getMessage(), "Ooops", 0);
                    e2.printStackTrace();
                }
                finally {
                    try {
                        if (outFile != null) {
                            outFile.close();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }
}

