/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class BaseFilePopulator {
    protected Logger logger = Logger.getLogger(this.getClass());
    private Map<String, String> placeholdersMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateFromFile(ClassPathResource resourceFile, Connection conn) throws Throwable {
        try {
            String[] queries;
            String content = "";
            try {
                File file = resourceFile.getFile();
                if (file != null) {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String line = null;
                    StringBuilder stringBuilder = new StringBuilder();
                    String ls = System.getProperty("line.separator");
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                        stringBuilder.append(ls);
                    }
                    content = stringBuilder.toString();
                    content = content.replaceAll("\\r\\n", "\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.placeholdersMap != null) {
                content = this.replacePlaceholders(content);
            }
            if ((queries = content.split("--NEXT_STATEMENT")) != null) {
                for (String query : queries) {
                    if (query.isEmpty() || query.trim().isEmpty()) continue;
                    this.logger.debug("execute stmt: " + query);
                    if (query.contains("call ") || query.contains("CALL ")) {
                        CallableStatement cs = null;
                        String storedProc = query;
                        cs = conn.prepareCall(storedProc);
                        cs.execute();
                        cs.close();
                        continue;
                    }
                    Statement statement = conn.createStatement();
                    statement.execute(query);
                    statement.close();
                }
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    private String replacePlaceholders(String content) {
        String result = content;
        if (this.placeholdersMap != null) {
            for (String placeholder : this.placeholdersMap.keySet()) {
                String replacement = this.placeholdersMap.get(placeholder);
                if (placeholder == null || placeholder.isEmpty() || replacement == null) continue;
                result = content.replace(placeholder, replacement);
            }
        }
        return result;
    }

    public Map<String, String> getPlaceholdersMap() {
        return this.placeholdersMap;
    }

    public void setPlaceholdersMap(Map<String, String> placeholdersMap) {
        this.placeholdersMap = placeholdersMap;
    }
}

