/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater;

import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;

public class DatabaseWrapper {
    protected Logger logger = Logger.getLogger(this.getClass());
    private static String ORA_CREATE_TABLE = "CREATE TABLE VX_UPDATES (\"ID\"     NUMBER NOT NULL ENABLE,\"APPLICATION\"   VARCHAR2(32 BYTE) NOT NULL ENABLE,\"TYPE\"   VARCHAR2(255 BYTE),\"AUTHOR\" VARCHAR2(255 BYTE),\"STATUS\" VARCHAR2(255 BYTE),\"TS_CREATE\" TIMESTAMP (6),\"TS_MOD\" TIMESTAMP (6),CONSTRAINT \"VX_UPDATES_PK\" PRIMARY KEY (\"ID\", \"APPLICATION\"))";
    private static String MYSQL_CREATE_TABLE = "CREATE TABLE VX_UPDATES (ID     bigint(20) NOT NULL,TYPE   VARCHAR(255), AUTHOR VARCHAR(255), STATUS VARCHAR(255), APPLICATION VARCHAR(255),TS_CREATE DATE, TS_MOD DATE, CONSTRAINT VX_UPDATES_PK PRIMARY KEY (ID, APPLICATION))";
    private static String MSSQL_CREATE_TABLE = "CREATE TABLE [VX_UPDATES]([ID] [bigint] NOT NULL,[TYPE] [varchar] (255) NULL,[AUTHOR] [varchar](255) NULL,[STATUS] [varchar](255) NULL,[APPLICATION] [varchar](255) NOT NULL,[TS_CREATE] [date] NULL,[TS_MOD] [date] NULL,CONSTRAINT [PK_VX_UPDATES] PRIMARY KEY CLUSTERED(\t[ID] ASC, [APPLICATION] ASC)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]";
    private String jdbcDriverClass;
    private String jdbcConnectionString;
    private String user;
    private String password;
    private String dialect;
    Connection conn;

    public DatabaseWrapper(String properties) throws Exception {
        Properties props = new Properties();
        props.load((InputStream)new StringInputStream(properties));
        this.jdbcDriverClass = (String)props.get("hibernate.connection.driver_class");
        this.jdbcConnectionString = (String)props.get("hibernate.connection.url");
        this.user = (String)props.get("hibernate.connection.username");
        this.password = (String)props.get("hibernate.connection.password");
        this.dialect = props.getProperty("hibernate.dialect");
        Class.forName(this.jdbcDriverClass);
        this.createTable();
    }

    protected void openConnection() throws SQLException {
        this.conn = DriverManager.getConnection(this.jdbcConnectionString, this.user, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTasksToDb(Collection<AbstractTask> tasks) {
        Connection conn = null;
        Statement st = null;
        try {
            String sql;
            conn = this.getConnection();
            if (this.dialect.contains("Oracle")) {
                sql = "MERGE INTO VX_UPDATES a USING dual ON ( a.ID=? AND a.APPLICATION=?) WHEN MATCHED THEN UPDATE SET a.TS_MOD = ?, a.STATUS = ?   WHEN NOT MATCHED THEN  INSERT (ID, APPLICATION, TYPE, AUTHOR, STATUS, TS_CREATE, TS_MOD) values(?,?,?,?,?,?,?)";
                st = conn.prepareStatement(sql);
                for (AbstractTask gut : tasks) {
                    try {
                        st.setLong(1, gut.id);
                        st.setString(2, gut.application);
                        Timestamp ts = new Timestamp(new Date().getTime());
                        st.setTimestamp(3, ts);
                        st.setString(4, gut.status);
                        st.setLong(5, gut.id);
                        st.setString(6, gut.application);
                        st.setString(7, gut.type);
                        st.setString(8, gut.author);
                        st.setString(9, gut.status);
                        st.setTimestamp(10, ts);
                        st.setTimestamp(11, ts);
                        st.executeUpdate();
                        this.logger.debug("Merged data for updateId =" + gut.id);
                    }
                    catch (Throwable t) {
                        this.logger.error("Merged failed for updateId =" + gut.id, t);
                    }
                }
            } else if (this.dialect.contains("MySQL")) {
                sql = "INSERT INTO VX_UPDATES (ID, APPLICATION, TYPE, AUTHOR, STATUS, TS_CREATE, TS_MOD) values(?,?,?,?,?,?,?)  ON DUPLICATE KEY  UPDATE TS_MOD = ?, STATUS = ?";
                conn = this.getConnection();
                st = conn.prepareStatement(sql);
                for (AbstractTask gut : tasks) {
                    try {
                        Timestamp ts = new Timestamp(new Date().getTime());
                        st.setLong(1, gut.id);
                        st.setString(2, gut.application);
                        st.setString(3, gut.type);
                        st.setString(4, gut.author);
                        st.setString(5, gut.status);
                        st.setTimestamp(6, ts);
                        st.setTimestamp(7, ts);
                        st.setTimestamp(8, ts);
                        st.setString(9, gut.status);
                        st.executeUpdate();
                        this.logger.debug("Merged data for updateId =" + gut.id);
                    }
                    catch (Throwable t) {
                        this.logger.error("Merged failed for updateId =" + gut.id, t);
                    }
                }
            } else if (this.dialect.contains("SQLServerDialect")) {
                sql = "MERGE VX_UPDATES AS TARGET  USING (select ? as ID, ? as APPLICATION) AS SOURCE  ON (TARGET.ID = SOURCE.ID AND TARGET.APPLICATION = SOURCE.APPLICATION )  WHEN MATCHED THEN  UPDATE SET TARGET.TS_MOD = ?, TARGET.STATUS = ?  WHEN NOT MATCHED THEN  INSERT (ID, APPLICATION, TYPE, AUTHOR, STATUS, TS_CREATE, TS_MOD) values(?,?,?,?,?,?,?);";
                conn = this.getConnection();
                st = conn.prepareStatement(sql);
                for (AbstractTask gut : tasks) {
                    try {
                        Timestamp ts = new Timestamp(new Date().getTime());
                        st.setLong(1, gut.id);
                        st.setString(2, gut.application);
                        st.setTimestamp(3, ts);
                        st.setString(4, gut.status);
                        st.setLong(5, gut.id);
                        st.setString(6, gut.application);
                        st.setString(7, gut.type);
                        st.setString(8, gut.author);
                        st.setString(9, gut.status);
                        st.setTimestamp(10, ts);
                        st.setTimestamp(11, ts);
                        st.executeUpdate();
                        this.logger.debug("MSSQL merged data for updateId =" + gut.id);
                    }
                    catch (Throwable t) {
                        this.logger.error("MSSQL merged failed for updateId =" + gut.id, t);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(t, t);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    this.logger.warn(e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.warn(e);
                }
            }
        }
    }

    public void evictOldTasks(List<AbstractTask> tasks) throws Exception {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            ArrayList<AbstractTask> tasksToRemove = new ArrayList<AbstractTask>();
            String sql = "select ID, APPLICATION, STATUS from VX_UPDATES order by ID";
            conn = this.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            block17: while (rs.next()) {
                Long id = rs.getLong(1);
                String app = rs.getString(2);
                String status = rs.getString(3);
                if (app == null) {
                    app = "";
                }
                for (AbstractTask gut : tasks) {
                    if (!id.equals(gut.id) || !app.equals(gut.application) || !gut.runatstartup.equals("0") || gut.runiffailed.equals("1") && status.equals("failed")) continue;
                    tasksToRemove.add(gut);
                    continue block17;
                }
            }
            this.logger.debug(String.format("Tasks to remove: %d", tasksToRemove.size()));
            tasks.removeAll(tasksToRemove);
        }
        catch (Throwable t) {
            this.logger.error(t, t);
            throw new Exception("evictOldTasks failed", t);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.warn(e);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    this.logger.warn(e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.warn(e);
                }
            }
        }
    }

    public Connection getConnection() throws SQLException {
        Connection result = null;
        if (this.conn != null && !this.conn.isClosed()) {
            result = this.conn;
        } else {
            this.openConnection();
            result = this.conn;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTable() throws Exception {
        block18: {
            Connection conn = null;
            try {
                conn = this.getConnection();
                Statement st = conn.createStatement();
                if (this.dialect.contains("Oracle")) {
                    st.addBatch(ORA_CREATE_TABLE);
                    this.logger.info("createSql=" + ORA_CREATE_TABLE);
                } else if (this.dialect.contains("MySQL")) {
                    st.addBatch(MYSQL_CREATE_TABLE);
                    this.logger.info("createSql=" + MYSQL_CREATE_TABLE);
                } else if (this.dialect.contains("SQLServerDialect")) {
                    st.addBatch(MSSQL_CREATE_TABLE);
                    this.logger.info("createSql=" + MSSQL_CREATE_TABLE);
                }
                st.executeBatch();
                this.logger.info("VX_UPDATES table created");
            }
            catch (Throwable t) {
                if (t.getMessage().contains("ORA-00955") || t.getMessage().contains("already exists") || t.getMessage().contains("There is already an object named")) {
                    this.logger.info("VX_UPDATES table already exists");
                    break block18;
                }
                this.logger.error(t, t);
                throw new Exception("create VX_UDPATES table failed", t);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        this.logger.warn(e);
                    }
                }
            }
        }
    }
}

