/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater;

import com.veraxsystems.commons.updater.XmlParser;
import com.veraxsystems.commons.updater.factory.AbstractTaskFactory;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskLoader {
    private Logger logger = Logger.getLogger(this.getClass());

    public List<AbstractTask> getUpdateTasks(Collection<File> files, AbstractTaskFactory factory) {
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
        for (File file : files) {
            List<AbstractTask> loaded = this.loadFromFile(file, factory);
            for (AbstractTask task : loaded) {
                if (tasks.contains(task)) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }

    private List<AbstractTask> loadFromFile(File file, AbstractTaskFactory factory) {
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
        try {
            XmlParser parser = new XmlParser(new FileInputStream(file));
            Node topNode = parser.getNode("update-tasks");
            Node appNode = topNode.getAttributes().getNamedItem("application");
            String application = "unspecified";
            if (appNode != null) {
                application = appNode.getNodeValue();
            }
            factory.setup(parser, application, file);
            NodeList nodeList = parser.getNodeList("update-tasks/task");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node taskNode = nodeList.item(i);
                    AbstractTask task = factory.createTask(taskNode);
                    if (task == null) continue;
                    tasks.add(task);
                }
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("FNFE: " + file, e);
        }
        return tasks;
    }

    public List<File> getUpdateFiles(String dirName) {
        File dir = this.getUpdateFolder(dirName);
        ArrayList<File> result = new ArrayList<File>();
        if (dir != null && dir.exists()) {
            this.logger.info("loading updates from " + dir);
            result.addAll(this.recursiveGetFiles(dir));
        } else {
            this.logger.warn("unable to load updates from " + dirName);
        }
        return result;
    }

    private File getUpdateFolder(String dirName) {
        ClassPathResource cpr = new ClassPathResource(dirName);
        try {
            if (cpr != null) {
                return cpr.getFile();
            }
        }
        catch (IOException e) {
            this.logger.warn(e);
        }
        return null;
    }

    private ArrayList<File> recursiveGetFiles(File updateLocation) {
        this.logger.info("processing path " + updateLocation);
        ArrayList<File> result = new ArrayList<File>();
        if (updateLocation.exists() && updateLocation.isDirectory()) {
            String[] children;
            for (String child : children = updateLocation.list()) {
                File childFile = new File(updateLocation.getAbsolutePath() + File.separator + child);
                if (childFile.exists() && childFile.isDirectory()) {
                    result.addAll(this.recursiveGetFiles(childFile));
                    continue;
                }
                if (!childFile.exists() || !childFile.isFile()) continue;
                this.logger.debug("adding file " + childFile);
                result.add(childFile);
            }
        } else if (updateLocation.exists() && updateLocation.isFile()) {
            this.logger.debug("adding file " + updateLocation);
            result.add(updateLocation);
        }
        return result;
    }
}

