/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser {
    private static final Logger logger = Logger.getLogger(XmlParser.class);
    protected Document doc;
    private XPathFactory xfactory;

    public XmlParser(String actionDefinitionXML) {
        this(actionDefinitionXML, false);
    }

    public XmlParser(String actionDefinitionXML, boolean namespaceAware) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(actionDefinitionXML.getBytes());
            this.doc = this.createFactory(namespaceAware).parse(byteArrayInputStream);
        }
        catch (Throwable t) {
            logger.error("Cannot create parser", t);
            throw new RuntimeException(t);
        }
    }

    public XmlParser(InputStream stream) {
        this(stream, false);
    }

    public XmlParser(InputStream stream, boolean namespaceAware) {
        try {
            this.doc = this.createFactory(namespaceAware).parse(stream);
        }
        catch (Throwable t) {
            logger.error("Cannot create parser", t);
            throw new RuntimeException(t);
        }
    }

    public XmlParser(URL url) {
        try {
            this.doc = this.createFactory(false).parse(url.toString());
        }
        catch (Throwable t) {
            logger.error("Cannot create parser", t);
            throw new RuntimeException(t);
        }
    }

    private DocumentBuilder createFactory(boolean namespaceAware) {
        try {
            logger.trace("Parsing actionsDefinition file.");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            logger.trace("Building DOM tree.");
            factory.setNamespaceAware(namespaceAware);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xfactory = XPathFactory.newInstance();
            logger.trace("DOM tree for action definition created.");
            return builder;
        }
        catch (Throwable t) {
            logger.error("Cannot build DOM tree for action definition", t);
            throw new RuntimeException(t);
        }
    }

    public String getValue(String path, Node toEvaluate) {
        try {
            XPath xpath = this.xfactory.newXPath();
            xpath.setNamespaceContext(this.getNamespaceContext());
            String value = xpath.evaluate(path, toEvaluate == null ? this.doc : toEvaluate);
            if (value != null) {
                value = value.trim();
            }
            return value;
        }
        catch (XPathExpressionException e) {
            logger.error("Cannot obtain value for xpath: " + path);
            throw new RuntimeException(e);
        }
    }

    public String getValue(String path) {
        return this.getValue(path, null);
    }

    public NodeList getNodeList(String path, Node toEvaluate) {
        try {
            XPath xpath = this.xfactory.newXPath();
            xpath.setNamespaceContext(this.getNamespaceContext());
            NodeList paramsNodes = (NodeList)xpath.evaluate(path, toEvaluate == null ? this.doc : toEvaluate, XPathConstants.NODESET);
            return paramsNodes;
        }
        catch (XPathExpressionException e) {
            logger.error("Cannot obtain value for xpath: " + path);
            throw new RuntimeException(e);
        }
    }

    public NodeList getNodeList(String path) {
        return this.getNodeList(path, null);
    }

    public Node getNode(String path, Node toEvaluate) {
        try {
            XPath xpath = this.xfactory.newXPath();
            xpath.setNamespaceContext(this.getNamespaceContext());
            Node value = (Node)xpath.evaluate(path, toEvaluate == null ? this.doc : toEvaluate, XPathConstants.NODE);
            return value;
        }
        catch (XPathExpressionException e) {
            logger.error("Cannot obtain value for xpath: " + path);
            throw new RuntimeException(e);
        }
    }

    public Node getNode(String path) {
        return this.getNode(path, null);
    }

    public boolean setAttribute(String pathToAttr, String value) {
        Node attr = this.getNode(pathToAttr, null);
        boolean result = false;
        if (attr == null) {
            String attrName = pathToAttr.substring(pathToAttr.lastIndexOf("/") + 1, pathToAttr.length());
            attrName = attrName.substring(attrName.lastIndexOf("@") + 1, attrName.length());
            attr = this.doc.createAttribute(attrName);
            attr.setTextContent(value);
            String parentsPath = pathToAttr.substring(0, pathToAttr.lastIndexOf("/"));
            NodeList parents = this.getNodeList(parentsPath);
            for (int i = 0; i < parents.getLength(); ++i) {
                parents.item(i).getAttributes().setNamedItem(attr);
                result = true;
            }
        } else {
            attr.setTextContent(value);
            result = true;
        }
        return result;
    }

    public boolean setTextContent(String pathToNode, String value) {
        Node node = this.getNode(pathToNode, null);
        boolean result = false;
        if (node == null) {
            String nodeName = pathToNode.substring(pathToNode.lastIndexOf("/") + 1, pathToNode.length());
            node = this.doc.createElement(nodeName);
            node.setTextContent(value);
            String parentsPath = pathToNode.substring(0, pathToNode.lastIndexOf("/"));
            NodeList parents = this.getNodeList(parentsPath);
            for (int i = 0; i < parents.getLength(); ++i) {
                parents.item(i).appendChild(node);
                result = true;
            }
        } else {
            node.setTextContent(value);
            result = true;
        }
        return result;
    }

    public boolean addChildNode(String pathToParentNode, Node child) {
        Node parent = this.getNode(pathToParentNode, null);
        if (parent != null) {
            parent.appendChild(child);
            return true;
        }
        return false;
    }

    public String getXml() throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(this.doc);
        transformer.transform(source, result);
        String xmlString = result.getWriter().toString();
        xmlString = xmlString.replaceAll("[\r\n]+", "\n");
        return xmlString;
    }

    public void validate(Document schemaDoc) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new DOMSource(schemaDoc));
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new SimpleErrorHandler());
        validator.validate(new DOMSource(this.doc));
        logger.debug("XML is valid");
    }

    public Document getDocument() {
        return this.doc;
    }

    protected NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return null;
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        };
    }

    private class SimpleErrorHandler
    implements ErrorHandler {
        private SimpleErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
            logger.error(exception.getMessage());
            throw new RuntimeException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            logger.fatal(exception.getMessage());
            throw new RuntimeException(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            logger.warn(exception.getMessage());
            throw new RuntimeException(exception);
        }
    }
}

