/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.conditions;

import com.veraxsystems.commons.updater.conditions.AbstractCondition;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ColumnExistsCondition
extends AbstractCondition {
    private static String ORACLE_TABLE_COLUMN_LOOKUP_QUERY = "SELECT COUNT(*) FROM ALL_TAB_COLUMNS WHERE table_name = UPPER(?) AND column_name = UPPER(?) AND OWNER = USER";
    private static String MYSQL_TABLE_COLUMN_LOOKUP_QUERY = "SELECT COUNT(*) FROM information_schema.COLUMNS WHERE table_schema = DATABASE() AND table_name = ? AND column_name = ?";
    private static String MSSQL_TABLE_COLUMN_LOOKUP_QUERY = "select count(*) from INFORMATION_SCHEMA.COLUMNS where upper(table_name) = ? AND upper(column_name) = ?";
    private final int TABLE_INDEX = 0;
    private final int COLUMN_INDEX = 1;

    @Override
    public Boolean execute(Connection conn) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        String[] parameters;
        Boolean result = false;
        String table = null;
        String tableColumn = null;
        String value = this.getProperty("value");
        if (value != null && (parameters = value.split(",")).length > 1) {
            table = parameters[0].trim().toUpperCase();
            tableColumn = parameters[1].trim().toUpperCase();
        }
        if (table != null && !table.trim().isEmpty() && tableColumn != null && !tableColumn.trim().isEmpty()) {
            int cnt;
            String driverName = conn.getMetaData().getDriverName().toLowerCase();
            String sql = "";
            if (driverName.contains("oracle")) {
                sql = ORACLE_TABLE_COLUMN_LOOKUP_QUERY;
            } else if (driverName.contains("mysql")) {
                sql = MYSQL_TABLE_COLUMN_LOOKUP_QUERY;
            } else if (driverName.contains("sql server")) {
                sql = MSSQL_TABLE_COLUMN_LOOKUP_QUERY;
            }
            ps = conn.prepareStatement(sql);
            ps.setString(1, table);
            ps.setString(2, tableColumn);
            rs = ps.executeQuery();
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        } else {
            this.logger.error("Condition checking failed in order to insufficient parameters - expected [table_name, column_name].");
            throw new RuntimeException("Condition checking failed in order to insufficient parameters - expected [table_name, column_name].");
        }
        rs.close();
        ps.close();
        return result;
    }
}

