/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.conditions;

import com.veraxsystems.commons.updater.conditions.AbstractCondition;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ConstraintExistsCondition
extends AbstractCondition {
    private static String ORACLE_CONSTRAINT_LOOKUP_QUERY = "select count(*) from all_constraints where constraint_name = ? and owner = USER";
    private static String MYSQL_CONSTRAINT_LOOKUP_QUERY = "SELECT count(*) FROM information_schema.table_constraints WHERE CONSTRAINT_NAME = ?";
    private static String MSSQL_CONSTRAINT_LOOKUP_QUERY = "select count(*) from INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS where lower(CONSTRAINT_NAME) = lower(?) ";

    @Override
    public Boolean execute(Connection conn) throws SQLException {
        int cnt;
        Boolean result = false;
        String driverName = conn.getMetaData().getDriverName().toLowerCase();
        String sql = "";
        if (driverName.contains("oracle")) {
            sql = ORACLE_CONSTRAINT_LOOKUP_QUERY;
        } else if (driverName.contains("mysql")) {
            sql = MYSQL_CONSTRAINT_LOOKUP_QUERY;
        } else if (driverName.contains("sql server")) {
            sql = MSSQL_CONSTRAINT_LOOKUP_QUERY;
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, this.getProperty("value"));
        ResultSet rs = ps.executeQuery();
        if (rs.next() && (cnt = rs.getInt(1)) > 0) {
            result = true;
        }
        rs.close();
        ps.close();
        return result;
    }
}

