/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.conditions;

import com.veraxsystems.commons.updater.conditions.AbstractCondition;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IndexExistsCondition
extends AbstractCondition {
    private static String ORACLE_INDEX_LOOKUP_QUERY = "select count(*) from dba_indexes where index_name = ? and owner = USER";
    private static String MYSQL_INDEX_LOOKUP_QUERY = "SELECT COUNT(*) FROM information_schema.columns WHERE COLUMN_KEY = ? ";
    private static String MSSQL_INDEX_LOOKUP_QUERY = "SELECT count(*) FROM sys.indexes i INNER JOIN sys.tables t ON i.object_id = t.object_id where lower(i.name) = lower(?) ";

    @Override
    public Boolean execute(Connection conn) throws SQLException {
        int cnt;
        Boolean result = false;
        String driverName = conn.getMetaData().getDriverName().toLowerCase();
        String sql = "";
        if (driverName.contains("oracle")) {
            sql = ORACLE_INDEX_LOOKUP_QUERY;
        } else if (driverName.contains("mysql")) {
            sql = MYSQL_INDEX_LOOKUP_QUERY;
        } else if (driverName.contains("sql server")) {
            sql = MSSQL_INDEX_LOOKUP_QUERY;
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, this.getProperty("value"));
        ResultSet rs = ps.executeQuery();
        if (rs.next() && (cnt = rs.getInt(1)) > 0) {
            result = true;
        }
        rs.close();
        ps.close();
        return result;
    }
}

