/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.conditions;

import com.veraxsystems.commons.updater.conditions.AbstractCondition;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TableExistsCondition
extends AbstractCondition {
    private static String ORACLE_TABLE_LOOKUP_QUERY = "select count(*) from ALL_ALL_TABLES where TABLE_NAME = ? AND OWNER = USER";
    private static String MYSQL_TABLE_LOOKUP_QUERY = "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = DATABASE() and table_name = ?";
    private static String MSSQL_TABLE_LOOKUP_QUERY = "select count(*) from INFORMATION_SCHEMA.TABLES where lower(TABLE_NAME) = lower(?) ";

    @Override
    public Boolean execute(Connection conn) throws SQLException {
        int cnt;
        Boolean result = false;
        String driverName = conn.getMetaData().getDriverName().toLowerCase();
        String sql = "";
        if (driverName.contains("oracle")) {
            sql = ORACLE_TABLE_LOOKUP_QUERY;
        } else if (driverName.contains("mysql")) {
            sql = MYSQL_TABLE_LOOKUP_QUERY;
        } else if (driverName.contains("sql server")) {
            sql = MSSQL_TABLE_LOOKUP_QUERY;
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, this.getProperty("value"));
        ResultSet rs = ps.executeQuery();
        if (rs.next() && (cnt = rs.getInt(1)) > 0) {
            result = true;
        }
        rs.close();
        ps.close();
        return result;
    }
}

