/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.factory;

import com.veraxsystems.commons.updater.INode;
import com.veraxsystems.commons.updater.XmlParser;
import com.veraxsystems.commons.updater.conditions.AbstractCondition;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.io.File;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTaskFactory {
    private Logger logger = Logger.getLogger(this.getClass());
    private File file;
    private XmlParser parser;
    private String application;

    public void setup(XmlParser parser, String application, File file) {
        this.file = file;
        this.parser = parser;
        this.application = application;
    }

    public AbstractTask createTask(Node node) {
        String type = this.parser.getValue("type", node);
        AbstractTask task = this.createEmptyTask(type);
        task.setType(type);
        task.setApplication(this.application);
        task.setId(this.parser.getValue("id", node), this.file);
        task.setAuthor(this.parser.getValue("author", node));
        task.setRunatstartup(this.parser.getValue("runatstartup", node));
        task.setRuniffailed(this.parser.getValue("runiffailed", node));
        this.registerConditions(task, node);
        this.registerProperties(task, node);
        return task;
    }

    private void registerConditions(AbstractTask task, Node node) {
        NodeList conditions = this.parser.getNodeList("conditions/condition", node);
        for (int i = 0; i < conditions.getLength(); ++i) {
            NamedNodeMap attrs = conditions.item(i).getAttributes();
            String type = attrs.getNamedItem("type").getNodeValue();
            AbstractCondition condition = this.createCondition(type);
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node item = attrs.item(j);
                condition.registerProperty(item.getNodeName(), item.getNodeValue());
            }
            this.registerProperties(condition, conditions.item(i));
            task.registerCondition(condition);
        }
    }

    private void registerProperties(INode task, Node node) {
        NodeList properties = this.parser.getNodeList("properties/property", node);
        for (int i = 0; i < properties.getLength(); ++i) {
            NamedNodeMap attrs = properties.item(i).getAttributes();
            String key = attrs.getNamedItem("name").getNodeValue();
            String value = attrs.getNamedItem("value").getNodeValue();
            if (key == null || value == null) {
                this.logger.error("malformed property (" + key + "," + value + ") in file " + this.file);
                continue;
            }
            task.registerProperty(key, value);
        }
    }

    public abstract AbstractTask createEmptyTask(String var1);

    public abstract AbstractCondition createCondition(String var1);
}

